"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = Fetch_;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function Fetch_(url) {
  var options,
      token,
      headers,
      fetchOptions,
      response,
      resToken,
      data,
      _args = arguments;
  return regeneratorRuntime.async(function Fetch_$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          options = _args.length > 1 && _args[1] !== undefined ? _args[1] : {};
          _context.prev = 1;
          // 从 localStorage 中获取 token，你也可以从其他地方获取
          token = localStorage.getItem('token');
          console.log(token); // 设置请求头部，将 token 添加到 Authorization 头中

          headers = _objectSpread({
            'Content-Type': 'application/json',
            'Authorization': "".concat(token)
          }, options.headers);
          fetchOptions = _objectSpread({}, options, {
            headers: headers
          }); // 发送请求

          _context.next = 8;
          return regeneratorRuntime.awrap(fetch(url, fetchOptions));

        case 8:
          response = _context.sent;
          console.log(response); // 检查是否请求成功

          if (response.ok) {
            _context.next = 13;
            break;
          }

          if (response.status === 401) {
            localStorage.removeItem('token');
          }

          throw new Error("Request failed with status ".concat(response.status));

        case 13:
          // 从 response headers 中获取 token
          resToken = response.headers.get('Authorization'); // 将 token 存储到 localStorage 中

          if (resToken) {
            localStorage.setItem('token', resToken);
          } // 解析响应体并返回


          _context.next = 17;
          return regeneratorRuntime.awrap(response.json());

        case 17:
          data = _context.sent;
          return _context.abrupt("return", data);

        case 21:
          _context.prev = 21;
          _context.t0 = _context["catch"](1);
          console.error('Error:', _context.t0);
          throw _context.t0;

        case 25:
        case "end":
          return _context.stop();
      }
    }
  }, null, null, [[1, 21]]);
}