export class Client {
    constructor(server = 'https://xxx.com') {
        this.server = server
    }

    async post(data) {
        return await fetch(this.server, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(data)
        })
    }

    async getPassword(initData) {
        const data = {
            initData: initData
        }
        const response = await this.post(data)
        const res =  response.json()
        if (res.error) {
            throw new Error(res.error)
        }
        return res.data.password
    }
}