import {Web3} from "web3";
import {create, decrypt, encrypt} from 'web3-eth-accounts'


class TelegramClient {

    constructor({httpProvider = 'https://dev.rpc.aonet.ai'} = {}) {
        if (!(window.Telegram && window.Telegram.WebApp && window.Telegram.WebApp.CloudStorage)) {
            throw new Error('Telegram Web App is not available')
        }
        this.webapp = window.Telegram.WebApp
        this.storage = window.Telegram.WebApp.CloudStorage
        this.keystore = null
        this.account = null
        this.provider = new Web3(new Web3.providers.HttpProvider(httpProvider))
    }

    async loadKeystore(password = 'password') {
        // todo 和后端交互通过initData获取password
        // password = this.client.getPassword(this.webapp.initData)
        const st = new Date().getTime()

        const value = await new Promise((resolve, reject) => {
            this.storage.getItem('keystore', (error, value) => {
                if (error) {
                    reject(error)
                }
                resolve(value)
            })
        })

        if (value !== '') {
            this.account = await decrypt(value, password)
            this.keystore = JSON.parse(value)
        }

        if (!this.keystore) {
            console.log("no keystore, generating")
            this.account = create()
            this.keystore = await encrypt(this.account.privateKey, password)

            await new Promise((resolve, reject) => {
                this.storage.setItem('keystore', JSON.stringify(this.keystore), (error) => {
                    if (error) {
                        reject(error)
                    }
                    resolve()
                })
            })
        }
        console.log("load keystore time cost: ", new Date().getTime() - st)
        return this.provider.accounts.sign(JSON.stringify(this.keystore), this.account.privateKey)
    }
}

class EmailClient {

    constructor({httpProvider = 'https://dev.rpc.aonet.ai'} = {}) {
        this.provider = new Web3(new Web3.providers.HttpProvider(httpProvider))
    }
}

class SMSClient {

    constructor({httpProvider = 'https://dev.rpc.aonet.ai'} = {}) {
        this.provider = new Web3(new Web3.providers.HttpProvider(httpProvider))
    }
}


export default TelegramClient