package types

type TaskTypeInfo struct {
	Id                int32  `json:"id"` // 任务类型id
	Name              string `json:"name"`
	Desc              string `json:"desc"`  // 任务类型描述
	Price             int64  `json:"price"` // 该任务类型的费用
	PublicKey         string `json:"public_key"`
	Complexity        int8   `json:"complexity"`
	HardwareRequire   string `json:"hardware_require"`
	ImageId           string `json:"image_id"`
	ImageUrl          string `json:"image_url"`
	ImageName         string `json:"image_name"`
	SignUrl           string `json:"sign_url"`
	Username          string `json:"username"`
	Password          string `json:"password"`
	Cmd               string `json:"cmd"`
	Workload          int32  `json:"workload"`
	ApiPath           string `json:"api_path"`
	Type              int8   `json:"type"` // 类型 1=txt2img 2=txt2txt 3=txt2video
	BaseModel         string `json:"base_model"`
	Model             string `json:"model"`
	Examples          string `json:"examples"`
	ApiDocUrl         string `json:"api_doc_url"`
	ApiDocContent     string `json:"api_doc_content"`
	Codes             string `json:"codes"`
	Tags              string `json:"tags"`
	Kind              int8   `json:"kind"` // 任务种类 SystemTask = 0; ComputeTask = 1; CustomTask = 2; StandardTask = 3;
	Category          int8   `json:"category"`
	ResultFileExpires int32  `json:"result_file_expires"`
	Version           string `json:"version"`
	Form              string `json:"form"`
	AccessStatus      int8   `json:"access_status"`    // 接入状体啊 1= 公开 2-= 私有
	EstimatExeTime    int32  `json:"estimat_exe_time"` // 预计执行时长
	Unit              string `json:"unit"`
	PublishStatus     int8   `json:"publish_status"` // 发布状态 1= 发布 2= 取消发布
	MaxExecTime       int32  `json:"max_exec_time"`  // 任务执行超时时间
}
