package standardlib

import (
	"encoding/json"
	"fmt"
	"math/rand"
)

type SmallCar struct {
}

func init() {
	RegisterStdLib("smallcar", &SmallCar{})
}

type TaskParam struct {
	Headers map[string][]string `json:"headers"`
	Queries map[string]string   `json:"queries"`
	Body    []byte              `json:"body"`
}

func (g *SmallCar) GenerateParam(difficult int) (string, error) {
	m := rand.Intn(256)

	body := fmt.Sprintf("{\n    \"model_name\": \"Realistic_Vision_V1.4\",\n    \"model_type\": \"tex2img\",\n    \"desc\": {\n        \"prompt\": \" a car with number %d\",\n        \"steps\": 20\n        }\n}", m)
	param := TaskParam{
		Headers: make(map[string][]string),
		Queries: make(map[string]string),
		Body:    []byte(body),
	}
	d, _ := json.Marshal(param)

	return string(d), nil
}

func (g *SmallCar) VerifyResult(param string, result []byte) bool {
	if len(result) > 0 {
		return true
	}
	return false
}
