package utils

import (
	"encoding/hex"
	"fmt"
	"github.com/ethereum/go-ethereum/crypto"
	"github.com/odysseus/service-registry/utils"
	"testing"
)

func TestCombineBytes(t *testing.T) {
	id := "9effda2d-f3ae-48e0-a54e-e88e84c6b804"
	idData := []byte(id)
	reqHash := "7c180aec90bf54c27988885fd1c5d2e7d48b2db50e871f24e55f6f4a2f6b1380"
	redData, _ := hex.DecodeString(reqHash)
	datahash := "4b42042af97e612aafd03b2ac7e57be39118dece1f1333f6db364aaf944fcd9d"
	data, _ := hex.DecodeString(datahash)

	signanture := "78006ed3cef7b2d15c47b53958fdc305ed1fda3bd4e4638a9033aeb52c9837b524f69e922da7844f557b7be4757ee8c355ef15ba6b3e31e0fc40ed403d9f72ec00"
	sigData, _ := hex.DecodeString(signanture)
	dataHash := crypto.Keccak256Hash(utils.CombineBytes(idData, redData, data))
	npubkey, err := crypto.SigToPub(dataHash[:], sigData)
	if err != nil {
		return
	}
	addr := crypto.PubkeyToAddress(*npubkey)
	fmt.Println("addr:", addr)
	//
	//hash := FromHex("0xaa81f776e43511492b9db11894c71e7fdca3f09bd24dc1fe93f1e017e6eef947")
	//pubkey := FromHex("0423965c5d5b4c2fa03fe024cfbcd413db25e7c420b73bd5dccb78fada9e22d4848d32952c913ae0cdcc70efa38094dc49c05c6a0cec7e1712557050da7d7bd05a")
	//signature := FromHex("db2be765e420d3b67e695612a349090e9fe2446c6b7875d36a0e6268bc3619e14d24b93a5d8f7f55b9649ad3f5a636a886c480fbe6fb5c49f3b716c0ea66ea7a01")
	//if len(signature) == 65 {
	//	signature = signature[:64]
	//}
	//if len(pubkey) > 65 {
	//	pubkey = pubkey[:65]
	//}
	//verified := crypto.VerifySignature(pubkey, hash, signature)
	//assert.Equal(t, verified, true)
}
