package config

import (
	"github.com/BurntSushi/toml"
	log "github.com/sirupsen/logrus"
	"io/ioutil"
)

type RedisConfig struct {
	Addr     string `json:"addr" toml:"addr"`
	Password string `json:"password" toml:"password"`
	DbIndex  int    `json:"db_index" toml:"db_index"`
}

type Config struct {
	PrivateKey string      `json:"private_key" toml:"private_key"`
	Endpoint   string      `json:"endpoint" toml:"endpoint"`
	MetricPort int         `json:"metrics_port" toml:"metrics_port"`
	Redis      RedisConfig `json:"redis" toml:"redis"`
}

var _cfg *Config = nil

func ParseConfig(path string) (*Config, error) {
	data, err := ioutil.ReadFile(path)
	if err != nil {
		log.Error("get config failed", "err", err)
		panic(err)
	}
	err = toml.Unmarshal(data, &_cfg)
	// err = json.Unmarshal(data, &_cfg)
	if err != nil {
		log.Error("unmarshal config failed", "err", err)
		panic(err)
	}
	return _cfg, nil
}

func GetConfig() *Config {
	return _cfg
}
