package server

import (
	"context"
	"github.com/odysseus/nodemanager/config"
	"strconv"
)

func (wm *WorkerManager) AddWorker(worker *Worker) error {
	for _, device := range worker.deviceInfo {
		// add device to redis
		priority := 0
		_ = device // todo: set priority with device info.
		if err := wm.rdb.LPush(context.Background(), config.WORKER_QUEUE_PREFIX+strconv.Itoa(priority), worker.uuid).Err(); err != nil {
			continue
		}
	}
	// add worker to redis queue
	if err := wm.rdb.SAdd(context.Background(), config.WORKER_STATUS_PREFIX+strconv.FormatInt(worker.uuid, 10), config.GetConfig().Endpoint).Err(); err != nil {
		return err
	}
	//wm.rdb.Set(context.Background(), config.WORKER_STATUS_PREFIX+strconv.FormatInt(worker.uuid, 10), odysseus.WorkerStatus_WorkerStatusActive, 0)
	return nil
}

func (wm *WorkerManager) ActiveWorker(worker *Worker) {
	wm.rdb.SAdd(context.Background(), config.WORKER_STATUS_PREFIX+strconv.FormatInt(worker.uuid, 10), config.GetConfig().Endpoint)
	//wm.rdb.Set(context.Background(), config.WORKER_STATUS_PREFIX+strconv.FormatInt(worker.uuid, 10), odysseus.WorkerStatus_WorkerStatusActive, 0)
}

func (wm *WorkerManager) InActiveWorker(worker *Worker) {
	wm.rdb.SRem(context.Background(), config.WORKER_STATUS_PREFIX+strconv.FormatInt(worker.uuid, 10), config.GetConfig().Endpoint)
	//wm.rdb.Set(context.Background(), config.WORKER_STATUS_PREFIX+strconv.FormatInt(worker.uuid, 10), odysseus.WorkerStatus_WorkerStatusInActive, 0)
}
