use mysql;

CREATE USER 'ai' @'127.0.0.1' identified BY 'RFnnKHRar5xk7TEF';

CREATE USER 'ai' @'%' identified BY 'RFnnKHRar5xk7TEF';

GRANT ALL ON *.* TO 'ai' @'%';

GRANT ALL ON *.* TO 'ai' @'127.0.0.1';

CREATE schema ai;

use ai;

create table ai_model
(
    id               int                      not null comment '模型id'
        primary key,
    name             varchar(255)             null comment '模型名称',
    `desc`           varchar(255)             null comment '模型描述',
    version          varchar(255)             null comment '版本',
    user_id          int                      null comment '发布者id',
    size             int(1) unsigned zerofill null comment '模型大小',
    suppot_hardware  varchar(255)             null comment '模型所支持的硬件',
    type             varchar(20)              null comment '模型类型',
    task_type_id     int                      null comment '关联的任务类型id',
    algorithms       varchar(20)              null comment '模型使用的算法',
    sample_image_url varchar(255)             null comment '示例图片地址',
    examples         text                     null,
    api_doc_url      varchar(255)             null,
    api_doc_content  text                     null,
    codes            text                     null,
    tags             varchar(255)             null,
    created_time     datetime                 not null on update CURRENT_TIMESTAMP comment '创建时间',
    updated_time     datetime                 not null on update CURRENT_TIMESTAMP comment '更新时间',
    deleted          tinyint default 0        null comment '逻辑删除'
);

create table api
(
    id           int               not null comment 'api  id'
        primary key,
    task_type_id int               null comment '对应的任务类型',
    name         varchar(20)       null comment '接口名称',
    `desc`       varchar(255)      null comment '接口描述',
    doc_path     varchar(255)      null comment '接口文档地址',
    deprecated   tinyint           null comment '是否废弃',
    created_time datetime          not null on update CURRENT_TIMESTAMP comment '创建时间',
    updated_time datetime          not null on update CURRENT_TIMESTAMP comment '更新时间',
    deleted      tinyint default 0 null comment '逻辑删除'
);

create table api_key
(
    id           int auto_increment comment 'App id'
        primary key,
    name         varchar(20)       null,
    api_key      varchar(255)      null comment 'App 唯一标识',
    api_key_id   varchar(255)      null,
    user_id      int               null comment '开发者用户id',
    region       int               null comment '区域',
    created_time datetime          not null on update CURRENT_TIMESTAMP comment '创建时间',
    updated_time datetime          not null on update CURRENT_TIMESTAMP comment '更新时间',
    deleted      tinyint default 0 null comment '逻辑删除'
);

create table bill_detail
(
    id              int auto_increment
        primary key,
    bill_start_time datetime                 null comment '账单开始时间',
    amout           bigint                   null comment '账单金额',
    user_id         int                      null comment '账单用户',
    api_id          int                      null comment '调用的api',
    api_call_count  int(2) unsigned zerofill null comment '调用api的总次数',
    bill_end_time   datetime                 null comment '账单结束时间',
    created_time    datetime                 not null on update CURRENT_TIMESTAMP comment '创建时间',
    updated_time    datetime                 not null on update CURRENT_TIMESTAMP comment '更新时间',
    deleted         tinyint default 0        null comment '逻辑删除'
);

create table charge_record
(
    id                    int auto_increment
        primary key,
    user_id               int                         null comment '充值用户',
    charge_time           datetime                    null comment '充值时间',
    amount                bigint(8) unsigned zerofill null comment '充值金额',
    status                tinyint                     null comment '充值状态
1=发起充值
2=待支付
3=支付成功
4=充值完成',
    pay_method            int(1) unsigned zerofill    null comment '支付路径
1=微信支付
2=支付宝支付
3=银联支付
4=paypal支付
5=apple支付',
    pay_method_desc       varchar(20)                 null,
    channel_serial_number int                         null,
    balance               bigint                      null,
    remark                varchar(255)                null,
    created_time          datetime                    not null on update CURRENT_TIMESTAMP comment '创建时间',
    updated_time          datetime                    not null on update CURRENT_TIMESTAMP comment '更新时间',
    deleted               tinyint default 0           null comment '逻辑删除'
);

create table jwt_token
(
    id             int auto_increment comment 'App id'
        primary key,
    name           varchar(20)       null,
    jwt_credential text              null comment 'app 密钥',
    jwt_token      varchar(255)      null,
    jwt_id         varchar(255)      null,
    user_id        int               null comment '开发者用户id',
    region         int               null comment '区域',
    created_time   datetime          not null on update CURRENT_TIMESTAMP comment '创建时间',
    updated_time   datetime          not null on update CURRENT_TIMESTAMP comment '更新时间',
    deleted        tinyint default 0 null comment '逻辑删除'
);

create table node_manager
(
    id           int               not null comment 'Node manager id'
        primary key,
    public_key   varchar(128)      null comment 'NM公钥',
    created_time datetime          not null on update CURRENT_TIMESTAMP comment '创建时间',
    updated_time datetime          not null on update CURRENT_TIMESTAMP comment '更新时间',
    deleted      tinyint default 0 null comment '逻辑删除'
);

create table task_history
(
    id           int auto_increment
        primary key,
    user_id      int                         null comment '用户id',
    task_id      varchar(255)                null comment '任务id',
    api_id       int                         null comment '调用的API',
    fee          bigint(7) unsigned zerofill null comment '实际花费',
    created_time datetime                    not null comment '创建时间',
    updated_time datetime                    not null comment '更新时间',
    deleted      int(1) unsigned zerofill    null comment '逻辑删除'
);

create table task_type
(
    id                  int auto_increment comment '任务类型id'
        primary key,
    name                varchar(255)        null,
    `desc`              text                null comment '任务类型描述',
    price               bigint              null comment '该任务类型的费用',
    public_key          binary(132)         null,
    complexity          tinyint             null,
    hardware_require    text                null,
    image_id            char(64)            null,
    image_url           varchar(255)        null,
    image_name          varchar(255)        null,
    sign_url            varchar(255)        null,
    username            varchar(255)        null,
    password            varchar(255)        null,
    cmd                 varchar(1024)       null,
    workload            int                 null,
    api_path            varchar(255)        null,
    type                tinyint             null comment '类型
1=txt2img
2=txt2txt
3=txt2video',
    base_model          varchar(255)        null,
    model               varchar(255)        null,
    examples            text                null,
    api_doc_url         varchar(255)        null,
    api_doc_content     text                null,
    codes               text                null,
    tags                varchar(255)        null,
    kind                tinyint             null comment '任务种类
SystemTask = 0;
ComputeTask = 1;
CustomTask = 2;
StandardTask = 3;',
    category            tinyint             null,
    result_file_expires int     default 600 null,
    version             varchar(255)        null,
    form                text                null,
    access_status       tinyint             null comment '接入状体啊
1= 公开
2-= 私有',
    publish_status      tinyint             null comment '发布状态
1= 发布
2= 取消发布',
    created_time        datetime            not null on update CURRENT_TIMESTAMP comment '创建时间',
    updated_time        datetime            not null on update CURRENT_TIMESTAMP comment '更新时间',
    deleted             tinyint default 0   null comment '逻辑删除'
);

create table total_bill
(
    id              int auto_increment
        primary key,
    user_id         int                         null comment '账单用户',
    amount          bigint(7) unsigned zerofill null comment '账单金额',
    bill_start_time datetime                    null comment '账单开始时间',
    bill_end_time   datetime                    null comment '账单结束时间',
    created_time    datetime                    not null comment '创建时间',
    updated_time    datetime                    not null comment '更新时间',
    deleted         tinyint                     null comment '逻辑删除'
);

create table user
(
    id                   int auto_increment comment '用户id'
        primary key,
    name                 varchar(120)           null comment '开发者名称',
    phone                varchar(15)            null comment '电话',
    mail                 varchar(120)           not null comment '邮箱',
    chain_account        varchar(42)            null comment '区块链账号',
    type                 tinyint     default 0  not null comment '用户类型：
1=自然人
2=企业',
    is_authed            tinyint                not null comment '是否实名',
    register_from        tinyint                not null comment '注册来源，三方账号',
    register_from_desc   varchar(16)            null comment '三方账户描述',
    username             varchar(20) default '' not null comment '开发者平台用户名',
    balance              bigint                 null comment '用户账户余额',
    level                int                    null comment '信用等级，决定免费调用额度',
    custom_id            varchar(12)            null comment '自定义kong的id',
    verifier_id          varchar(255)           null,
    rate_limit_plugin_id varchar(255)           null,
    profile_image        varchar(255)           null,
    role                 tinyint                null comment '角色
1，超级管理员
2，管理员
3，开发者管理员
4，普通开发者',
    created_time         datetime               not null on update CURRENT_TIMESTAMP comment '创建时间',
    updated_time         datetime               not null on update CURRENT_TIMESTAMP comment '更新时间',
    deleted              tinyint     default 0  null comment '逻辑删除'
);

create table user_level
(
    id                    int auto_increment comment '信用等级id'
        primary key,
    level                 int               not null comment '等级',
    `desc`                varchar(20)       null comment '描述',
    credit_quota          bigint            null comment '该等级免费额度',
    free_call_count_day   int               null comment '免费调用次数',
    free_call_count_month int               null,
    free_call_count_year  int               null,
    free_call_count_total int               null,
    rate_limit_second     int               null comment '该等级调用频率',
    rate_limit_minute     int               null,
    rate_limit_hour       int               null,
    rate_limit_day        int               null,
    rate_limit_month      int               null,
    rate_limit_year       bigint            null,
    price                 bigint            null,
    discounted_price      bigint            null,
    created_time          datetime          not null on update CURRENT_TIMESTAMP comment '创建时间',
    updated_time          datetime          not null on update CURRENT_TIMESTAMP comment '更新时间',
    deleted               tinyint default 0 null comment '逻辑删除'
);

create table user_level_task_type
(
    id                    int auto_increment
        primary key,
    free_call_count_day   int               null,
    free_call_count_month int               null,
    free_call_count_year  int               null,
    free_call_count_total int               null,
    user_level            int               null,
    task_type_id          int               null,
    created_time          datetime          not null on update CURRENT_TIMESTAMP,
    updated_time          datetime          not null on update CURRENT_TIMESTAMP,
    deleted               tinyint default 0 null
);

create table withdrawal_conf
(
    id           int auto_increment
        primary key,
    card_no      varchar(20)       null comment '提现银行卡号',
    card_bank    varchar(20)       null comment '提现银行开户行',
    card_account varchar(20)       null comment '提现账户名称',
    user_id      int               null comment '用户Id',
    created_time datetime          not null on update CURRENT_TIMESTAMP comment '创建时间',
    updated_time datetime          not null on update CURRENT_TIMESTAMP comment '更新时间',
    deleted      tinyint default 0 null comment '逻辑删除'
);

create table withdrawal_record
(
    id              int auto_increment
        primary key,
    withdrawal_time datetime          not null on update CURRENT_TIMESTAMP comment '提现时间',
    amount          bigint            null comment '提现金额',
    status          tinyint           null comment '提现状态
1=发起提现
2=提现转账
3=转账成功
4=提现完成',
    created_time    datetime          not null on update CURRENT_TIMESTAMP comment '创建时间',
    updated_time    datetime          not null on update CURRENT_TIMESTAMP comment '更新时间',
    deleted         tinyint default 0 null comment '逻辑删除'
);



insert into api_key (id, name, api_key, api_key_id, user_id, region, created_time, updated_time, deleted)
values  (34, 'firat', 'xotE2jfTxJmnrDweUPRUJC8VKkdIjHIF', '92c7657e-2a39-4c14-b9c1-c5241b73e83f', 23, null, '2024-02-02 12:16:31', '2024-02-02 12:16:31', 0),
        (35, 'test', '8f1phYms7sQ9JKJpdluWZqwWGxdetGGb', 'd7b31e02-fd13-45d1-bd4f-60196c082f08', 24, null, '2024-02-02 14:34:34', '2024-02-02 14:34:34', 0),
        (36, 'api-key-1', 'hyLF8R2M6XYMKUlQg8CBU4RyCigUv0wZ', 'c776102a-fba2-4e21-aa53-3f03532c4d4e', 26, null, '2024-02-22 09:15:39', '2024-02-22 09:15:39', 0),
        (37, '123', 'wMxsSY5JEQYOrLRtFSfjIUwjVbj07x5C', 'e3ab70bd-21b7-43c8-8323-94b8ad4efdc4', 27, null, '2024-03-09 14:15:45', '2024-03-09 14:15:45', 0),
        (38, 'test22', 'QCgEVChqfozD5ahbjVwzIPY3CqCWELz0', 'a400f622-7a97-416b-a82b-cc92df84f293', 25, null, '2024-03-10 16:33:47', '2024-03-10 16:33:47', 0);

insert into ai.charge_record (id, user_id, charge_time, amount, status, pay_method, pay_method_desc, channel_serial_number, balance, remark, created_time, updated_time, deleted)
values  (1, 26, '2024-02-22 09:16:04', 10000000000, 1, 6, '手动充值', null, null, null, '2024-02-22 09:16:04', '2024-02-22 09:16:04', 0);

insert into jwt_token (id, name, jwt_credential, jwt_token, jwt_id, user_id, region, created_time, updated_time, deleted)
values  (1, 'test', '{"consumer":{"id":"a34d9e9a-6b08-4328-acbd-c5388ef41f52"},"key":"ixqrQ9JwxbkULoRvQ1f53SngKQfIHSFF","id":"f7087b04-4c3b-4c2a-aee9-5acf651ae942","created_at":1710078875,"secret":"SEntKkAtSlGu2Zzz0xQV5FBaGTTOfbK8","algorithm":"HS256","rsa_public_key":null,"tags":null}', 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJpeHFyUTlKd3hia1VMb1J2UTFmNTNTbmdLUWZJSFNGRiJ9.R7lLvCCYhVdfnOJ0F73vEzBHQq5OtBpflkww0NyG93k', 'f7087b04-4c3b-4c2a-aee9-5acf651ae942', 25, null, '2024-03-10 13:54:36', '2024-03-10 13:54:36', 0);

insert into task_type (id, name, `desc`, price, public_key, complexity, hardware_require, image_id, image_url, image_name, sign_url, username, password, cmd, workload, api_path, `type`, base_model, model, examples, api_doc_url, api_doc_content, codes, tags, kind, category, result_file_expires, version, form, access_status, publish_status, created_time, updated_time, deleted)
values  (12, 'test', '文生图', 1000000, 0x000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 1, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'demianhjw/aigic:0129', 'http://124.193.167.71:8018/llm/test/get/sign', '', '', '{"image_name":"demianhjw/aigic:0129","docker_cmd":{"container_port":"5001"},"api_url":"http://127.0.0.1:%d/aigic"}', 100, '/txt2Img/demianhjw/aigic', 1, 'base', null, null, null, null, null, null, 1, null, null, null, null, null, null, '2024-03-09 17:37:42', '2024-03-09 17:37:42', 0),
        (13, 'sd-1.5', 'Stable Diffusion is a latent text-to-image diffusion model capable of generating photo-realistic images given any text input.', 1000000, 0x307830336238303934316664303362623864323863613730383335323536363339613835353535316131333964636564656432643631393030646330363238663364623900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'demianhjw/aigic:0129', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/aigic","docker_cmd":{"container_port":5001},"image_name":"demianhjw/aigic:0129"}', 105, '/txt2img/sd-1.5/base', 1, 'sd-1.5', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-05 10:51:58', '2024-03-05 10:51:58', 0),
        (14, 'chatglm2-6b', 'ChatGLM2-6B is the second-generation version of the open-source bilingual (Chinese-English) chat model ChatGLM-6B. It retains the smooth conversation flow and low deployment threshold of the first-generation model, while introducing the new features including stronger performance, longer contex and more efficient inference.', 1000000, 0x307830336238303934316664303362623864323863613730383335323536363339613835353535316131333964636564656432643631393030646330363238663364623900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'demianhjw/aigic:0129', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/aigic","docker_cmd":{"container_port":4959},"image_name":"demianhjw/aigic:0129"}', 100, '/txt2txt/chatglm2-6b/base', 2, 'chatglm2-6b', 'base', '', '', '', '', '', 1, 1, null, '', null, null, null, '2024-03-05 10:52:06', '2024-03-05 10:52:06', 0),
        (15, 'glid-3-xl', 'CompVis’ 1.4B parameter Latent Diffusion Text-To-Image model finetuned for inpainting, logo generation, art generation and more', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/afiaka87/glid-3-xl:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/afiaka87/glid-3-xl:latest"}', 100, '/txt2img/glid-3-xl/base', 1, 'glid-3-xl', 'base', '[{"title":"cat","input": {
    "seed": -1,
    "steps": 100,
    "width": 256,
    "height": 256,
    "prompt": "a giant cat sleeping on the beach",
    "batch_size": 1,
    "guidance_scale": 5,
    "aesthetic_rating": 9,
    "aesthetic_weight": 0.5
  },"output":[
    [
      "https://replicate.delivery/mgxm/1c887c1b-1022-4117-bba4-cf454ca07228/current_0.png"
    ]
  ]},
  {"title":"pikachu","input":{
    "seed": -1,
    "steps": 100,
    "width": 256,
    "height": 256,
    "prompt": "pikachu rendered in pixar",
    "batch_size": 1,
    "guidance_scale": 5,
    "aesthetic_rating": 9,
    "aesthetic_weight": 0.5
  },"output": [
    [
      "https://replicate.delivery/mgxm/804c6fe5-d74a-4796-8835-f411b3776dae/current_0.png"
    ]
  ]}]', '', '', '{
    "javascript": "const axios = require(''axios'');\\n\\n// 替换成你的 API 密钥和 API URL\\nconst API_KEY = $API_KEY;\\nconst API_URL = $END_POINT + $API_PATH;\\nconst data = {\\"input\\":$INPUT}\\n\\n// 设置请求头，包含 API 密钥\\nconst headers = {\\n    ''apikey'': API_KEY,\\n    ''Content-Type'': ''application/json''\\n};\\n\\n// 发送 GET 请求\\naxios.get(API_URL, { headers })\\n    .then(response => {\\n        // 打印返回的 JSON 数据\\n        console.log(''Response:'', response.data);\\n    })\\n    .catch(error => {\\n        // 处理错误\\n        console.error(''Error:'', error);\\n    });",
    "python": "# 定义请求的 URL 和要发送的数据\\nurl = $END_POINT + $API_PATH\\ndata = {\\"input\\":$INPUT}\\n\\n# 定义 API Key\\napi_key = $API_KEY\\n\\n# 设置请求头\\nheaders = {apikey'': api_key}\\n# 发送 POST 请求\\nresponse = requests.post(url, data=data, headers=headers)\\n\\n# 检查响应\\nif response.status_code == 200:\\n    print(\\"HTTP POST 请求成功！\\")\\n    # 打印\\nprint(response.content)\\nelse:\\n    print(\\"HTTP POST 请求失败！\\")\\n    print(\\"响应状态码:\\", response.status_code)"
}', '["image"]', 1, 2, 1800, '', '{"openapi":"3.0.2","info":{"title":"Cog","version":"0.1.0"},"paths":{"/":{"get":{"summary":"Root","operationId":"root__get","responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{}}}}}}},"/predictions":{"post":{"summary":"Predict","description":"Run a single prediction on the model","operationId":"predict_predictions_post","requestBody":{"content":{"application/json":{"schema":{"$ref":"#/components/schemas/Request"}}}},"responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"$ref":"#/components/schemas/Response"}}}},"422":{"description":"Validation Error","content":{"application/json":{"schema":{"$ref":"#/components/schemas/HTTPValidationError"}}}}}}}},"components":{"schemas":{"HTTPValidationError":{"title":"HTTPValidationError","type":"object","properties":{"detail":{"title":"Detail","type":"array","items":{"$ref":"#/components/schemas/ValidationError"}}}},"Input":{"title":"Input","type":"object","properties":{"prompt":{"title":"Prompt","type":"string","description":"Your text prompt.","default":"","x-order":0},"negative":{"title":"Negative","type":"string","description":"(optional) Negate the model''s prediction for this text from the model''s prediction for the target text.","default":"","x-order":1},"init_image":{"title":"Init Image","type":"string","description":"(optional) Initial image to use for the model''s prediction. If provided alongside a mask, the image will be inpainted instead.","format":"uri","x-order":2},"mask":{"title":"Mask","type":"string","description":"a mask image for inpainting an init_image. white pixels = keep, black pixels = discard. resized to width = image width/8, height = image height/8","format":"uri","x-order":3},"guidance_scale":{"title":"Guidance Scale","maximum":100.0,"minimum":-20.0,"type":"number","description":"Classifier-free guidance scale. Higher values will result in more guidance toward caption, with diminishing returns. Try values between 1.0 and 40.0. In general, going above 5.0 will introduce some artifacting.","default":5.0,"x-order":4},"steps":{"title":"Steps","maximum":250.0,"minimum":15.0,"type":"integer","description":"Number of diffusion steps to run. Due to PLMS sampling, using more than 100 steps is unnecessary and may simply produce the exact same output.","default":50,"x-order":5},"batch_size":{"title":"Batch Size","maximum":16.0,"minimum":1.0,"type":"integer","description":"Batch size. (higher = slower)","default":4,"x-order":6},"width":{"allOf":[{"$ref":"#/components/schemas/width"}],"description":"Target width","default":256,"x-order":7},"height":{"allOf":[{"$ref":"#/components/schemas/height"}],"description":"Target height","default":256,"x-order":8},"init_skip_fraction":{"title":"Init Skip Fraction","maximum":1.0,"minimum":0.0,"type":"number","description":"Fraction of sampling steps to skip when using an init image. Defaults to 0.0 if init_image is not specified and 0.5 if init_image is specified.","default":0.0,"x-order":9},"aesthetic_rating":{"title":"Aesthetic Rating","type":"integer","description":"Aesthetic rating (1-9) - embed to use.","default":9,"x-order":10},"aesthetic_weight":{"title":"Aesthetic Weight","type":"number","description":"Aesthetic weight (0-1). How much to guide towards the aesthetic embed vs the prompt embed.","default":0.5,"x-order":11},"seed":{"title":"Seed","maximum":4294967295.0,"minimum":-1.0,"type":"integer","description":"Seed for random number generator. If -1, a random seed will be chosen.","default":-1,"x-order":12},"intermediate_outputs":{"title":"Intermediate Outputs","type":"boolean","description":"Whether to return intermediate outputs. Enable to visualize the diffusion process and/or debug the model. May slow down inference.","default":false,"x-order":13}}},"Output":{"title":"Output","type":"array","items":{"type":"array","items":{"type":"string","format":"uri"}},"x-cog-array-type":"iterator"},"Request":{"title":"Request","type":"object","properties":{"input":{"$ref":"#/components/schemas/Input"},"output_file_prefix":{"title":"Output File Prefix","type":"string"}},"description":"The request body for a prediction"},"Response":{"title":"Response","required":["status"],"type":"object","properties":{"status":{"$ref":"#/components/schemas/Status"},"output":{"$ref":"#/components/schemas/Output"},"error":{"title":"Error","type":"string"}},"description":"The response body for a prediction"},"Status":{"title":"Status","enum":["processing","succeeded","failed"],"type":"string","description":"An enumeration."},"ValidationError":{"title":"ValidationError","required":["loc","msg","type"],"type":"object","properties":{"loc":{"title":"Location","type":"array","items":{"anyOf":[{"type":"string"},{"type":"integer"}]}},"msg":{"title":"Message","type":"string"},"type":{"title":"Error Type","type":"string"}}},"height":{"title":"height","enum":[128,192,256,320,384],"type":"integer","description":"An enumeration."},"width":{"title":"width","enum":[128,192,256,320,384],"type":"integer","description":"An enumeration."}}}}
', 1, 1, '2024-03-08 18:42:17', '2024-03-08 18:42:17', 0),
        (16, 'stable-diffusion', 'A latent text-to-image diffusion model capable of generating photo-realistic images given any text input', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/stability-ai/stable-diffusion:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/stability-ai/stable-diffusion:latest"}', 100, '/predictions/stability-ai/stable-diffusion', 1, 'stable-diffusion', 'base', '[{"title":"astronaut","input": {
        "width": 768,
        "height": 768,
        "prompt": "an astronaut riding a horse on mars, hd, dramatic lighting",
        "scheduler": "K_EULER",
        "num_outputs": 1,
        "guidance_scale": 7.5,
        "num_inference_steps": 50
    },"output":[
    "https://replicate.delivery/pbxt/sWeZFZou6v3CPKuoJbqX46ugPaHT1DcsWYx0srPmGrMOCPYIA/out-0.png"
  ]},
  {"title":"otter","input":{
    "prompt": "a gentleman otter in a 19th century portrait",
    "num_outputs": 1,
    "guidance_scale": 7.5,
    "num_inference_steps": 100
  },"output": [
    "https://replicate.delivery/mgxm/8d6a8069-b91f-4e61-8136-fa7c0775532c/out-0.png"
  ]}]', '', '', '{
    "javascript": "const axios = require(''axios'');\\n\\n// 替换成你的 API 密钥和 API URL\\nconst API_KEY = $API_KEY;\\nconst API_URL = $END_POINT + $API_PATH;\\nconst data = {\\"input\\":$INPUT}\\n\\n// 设置请求头，包含 API 密钥\\nconst headers = {\\n    ''apikey'': API_KEY,\\n    ''Content-Type'': ''application/json''\\n};\\n\\n// 发送 GET 请求\\naxios.get(API_URL, { headers })\\n    .then(response => {\\n        // 打印返回的 JSON 数据\\n        console.log(''Response:'', response.data);\\n    })\\n    .catch(error => {\\n        // 处理错误\\n        console.error(''Error:'', error);\\n    });",
    "python": "# 定义请求的 URL 和要发送的数据\\nurl = $END_POINT + $API_PATH\\ndata = {\\"input\\":$INPUT}\\n\\n# 定义 API Key\\napi_key = $API_KEY\\n\\n# 设置请求头\\nheaders = {apikey'': api_key}\\n# 发送 POST 请求\\nresponse = requests.post(url, data=data, headers=headers)\\n\\n# 检查响应\\nif response.status_code == 200:\\n    print(\\"HTTP POST 请求成功！\\")\\n    # 打印\\nprint(response.content)\\nelse:\\n    print(\\"HTTP POST 请求失败！\\")\\n    print(\\"响应状态码:\\", response.status_code)"
}', '["image"]', 1, 2, 1800, '', '{"openapi":"3.1.0","info":{"title":"Cog","version":"0.1.0"},"paths":{"/":{"get":{"summary":"Root","operationId":"root__get","responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"title":"Response Root  Get"}}}}}}},"/health-check":{"get":{"summary":"Healthcheck","operationId":"healthcheck_health_check_get","responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"title":"Response Healthcheck Health Check Get"}}}}}}},"/predictions":{"post":{"summary":"Predict","description":"Run a single prediction on the model","operationId":"predict_predictions_post","parameters":[{"required":false,"schema":{"type":"string","title":"Prefer"},"name":"prefer","in":"header"}],"requestBody":{"content":{"application/json":{"schema":{"$ref":"#/components/schemas/PredictionRequest"}}}},"responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"$ref":"#/components/schemas/PredictionResponse"}}}},"422":{"description":"Validation Error","content":{"application/json":{"schema":{"$ref":"#/components/schemas/HTTPValidationError"}}}}}}},"/predictions/{prediction_id}":{"put":{"summary":"Predict Idempotent","description":"Run a single prediction on the model (idempotent creation).","operationId":"predict_idempotent_predictions__prediction_id__put","parameters":[{"required":true,"schema":{"type":"string","title":"Prediction ID"},"name":"prediction_id","in":"path"},{"required":false,"schema":{"type":"string","title":"Prefer"},"name":"prefer","in":"header"}],"requestBody":{"content":{"application/json":{"schema":{"allOf":[{"$ref":"#/components/schemas/PredictionRequest"}],"title":"Prediction Request"}}},"required":true},"responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"$ref":"#/components/schemas/PredictionResponse"}}}},"422":{"description":"Validation Error","content":{"application/json":{"schema":{"$ref":"#/components/schemas/HTTPValidationError"}}}}}}},"/predictions/{prediction_id}/cancel":{"post":{"summary":"Cancel","description":"Cancel a running prediction","operationId":"cancel_predictions__prediction_id__cancel_post","parameters":[{"required":true,"schema":{"type":"string","title":"Prediction ID"},"name":"prediction_id","in":"path"}],"responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"title":"Response Cancel Predictions  Prediction Id  Cancel Post"}}}},"422":{"description":"Validation Error","content":{"application/json":{"schema":{"$ref":"#/components/schemas/HTTPValidationError"}}}}}}},"/shutdown":{"post":{"summary":"Start Shutdown","operationId":"start_shutdown_shutdown_post","responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"title":"Response Start Shutdown Shutdown Post"}}}}}}}},"components":{"schemas":{"HTTPValidationError":{"properties":{"detail":{"items":{"$ref":"#/components/schemas/ValidationError"},"type":"array","title":"Detail"}},"type":"object","title":"HTTPValidationError"},"Input":{"properties":{"prompt":{"type":"string","title":"Prompt","description":"Input prompt","default":"a vision of paradise. unreal engine","x-order":0},"height":{"allOf":[{"$ref":"#/components/schemas/height"}],"description":"Height of generated image in pixels. Needs to be a multiple of 64","default":768,"x-order":1},"width":{"allOf":[{"$ref":"#/components/schemas/width"}],"description":"Width of generated image in pixels. Needs to be a multiple of 64","default":768,"x-order":2},"negative_prompt":{"type":"string","title":"Negative Prompt","description":"Specify things to not see in the output","x-order":3},"num_outputs":{"type":"integer","maximum":4.0,"minimum":1.0,"title":"Num Outputs","description":"Number of images to generate.","default":1,"x-order":4},"num_inference_steps":{"type":"integer","maximum":500.0,"minimum":1.0,"title":"Num Inference Steps","description":"Number of denoising steps","default":50,"x-order":5},"guidance_scale":{"type":"number","maximum":20.0,"minimum":1.0,"title":"Guidance Scale","description":"Scale for classifier-free guidance","default":7.5,"x-order":6},"scheduler":{"allOf":[{"$ref":"#/components/schemas/scheduler"}],"description":"Choose a scheduler.","default":"DPMSolverMultistep","x-order":7},"seed":{"type":"integer","title":"Seed","description":"Random seed. Leave blank to randomize the seed","x-order":8}},"type":"object","title":"Input"},"Output":{"items":{"type":"string","format":"uri"},"type":"array","title":"Output"},"PredictionRequest":{"properties":{"input":{"$ref":"#/components/schemas/Input"},"id":{"type":"string","title":"Id"},"created_at":{"type":"string","format":"date-time","title":"Created At"},"output_file_prefix":{"type":"string","title":"Output File Prefix"},"webhook":{"type":"string","maxLength":65536,"minLength":1,"format":"uri","title":"Webhook"},"webhook_events_filter":{"items":{"$ref":"#/components/schemas/WebhookEvent"},"type":"array","uniqueItems":true,"default":["start","completed","logs","output"]}},"type":"object","title":"PredictionRequest"},"PredictionResponse":{"properties":{"input":{"$ref":"#/components/schemas/Input"},"output":{"$ref":"#/components/schemas/Output"},"id":{"type":"string","title":"Id"},"version":{"type":"string","title":"Version"},"created_at":{"type":"string","format":"date-time","title":"Created At"},"started_at":{"type":"string","format":"date-time","title":"Started At"},"completed_at":{"type":"string","format":"date-time","title":"Completed At"},"logs":{"type":"string","title":"Logs","default":""},"error":{"type":"string","title":"Error"},"status":{"$ref":"#/components/schemas/Status"},"metrics":{"type":"object","title":"Metrics"}},"type":"object","title":"PredictionResponse"},"Status":{"type":"string","enum":["starting","processing","succeeded","canceled","failed"],"title":"Status","description":"An enumeration."},"ValidationError":{"properties":{"loc":{"items":{"anyOf":[{"type":"string"},{"type":"integer"}]},"type":"array","title":"Location"},"msg":{"type":"string","title":"Message"},"type":{"type":"string","title":"Error Type"}},"type":"object","required":["loc","msg","type"],"title":"ValidationError"},"WebhookEvent":{"type":"string","enum":["start","output","logs","completed"],"title":"WebhookEvent","description":"An enumeration."},"height":{"type":"integer","enum":[64,128,192,256,320,384,448,512,576,640,704,768,832,896,960,1024],"title":"height","description":"An enumeration."},"scheduler":{"type":"string","enum":["DDIM","K_EULER","DPMSolverMultistep","K_EULER_ANCESTRAL","PNDM","KLMS"],"title":"scheduler","description":"An enumeration."},"width":{"type":"integer","enum":[64,128,192,256,320,384,448,512,576,640,704,768,832,896,960,1024],"title":"width","description":"An enumeration."}}}}
', 1, 1, '2024-03-08 18:42:21', '2024-03-08 18:42:21', 0),
        (17, 'sdxl', 'A text-to-image generative AI model that creates beautiful images', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/stability-ai/sdxl:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/stability-ai/sdxl:latest"}', 100, '/predictions/stability-ai/sdxl', 1, 'sdxl', 'base', '[{"title":"astronaut","input": {
        "width": 768,
        "height": 768,
        "prompt": "An astronaut riding a rainbow unicorn, cinematic, dramatic",
        "refine": "expert_ensemble_refiner",
        "scheduler": "K_EULER",
        "lora_scale": 0.6,
        "num_outputs": 1,
        "guidance_scale": 7.5,
        "apply_watermark": false,
        "high_noise_frac": 0.8,
        "negative_prompt": "",
        "prompt_strength": 0.8,
        "num_inference_steps": 25
    },"output":[
    "https://pbxt.replicate.delivery/YXbcLudoHBIYHV6L0HbcTx5iRzLFMwygLr3vhGpZI35caXbE/out-0.png"
  ]},
  {"title":"cat","input":{
    "width": 1024,
    "height": 1024,
    "prompt": "A studio photo of a rainbow coloured cat",
    "refine": "expert_ensemble_refiner",
    "scheduler": "KarrasDPM",
    "num_outputs": 1,
    "guidance_scale": 7.5,
    "high_noise_frac": 0.8,
    "prompt_strength": 0.8,
    "num_inference_steps": 50
  },"output": [
    "https://replicate.delivery/pbxt/V1IpaG4oVXofGyZcPxhhVVfEFvaMx9lMzqR9Fh4RpsRwyyTRA/out-0.png"
  ]}]', '', '', '{
    "javascript": "const axios = require(''axios'');\\n\\n// 替换成你的 API 密钥和 API URL\\nconst API_KEY = $API_KEY;\\nconst API_URL = $END_POINT + $API_PATH;\\nconst data = {\\"input\\":$INPUT}\\n\\n// 设置请求头，包含 API 密钥\\nconst headers = {\\n    ''apikey'': API_KEY,\\n    ''Content-Type'': ''application/json''\\n};\\n\\n// 发送 GET 请求\\naxios.get(API_URL, { headers })\\n    .then(response => {\\n        // 打印返回的 JSON 数据\\n        console.log(''Response:'', response.data);\\n    })\\n    .catch(error => {\\n        // 处理错误\\n        console.error(''Error:'', error);\\n    });",
    "python": "# 定义请求的 URL 和要发送的数据\\nurl = $END_POINT + $API_PATH\\ndata = {\\"input\\":$INPUT}\\n\\n# 定义 API Key\\napi_key = $API_KEY\\n\\n# 设置请求头\\nheaders = {apikey'': api_key}\\n# 发送 POST 请求\\nresponse = requests.post(url, data=data, headers=headers)\\n\\n# 检查响应\\nif response.status_code == 200:\\n    print(\\"HTTP POST 请求成功！\\")\\n    # 打印\\nprint(response.content)\\nelse:\\n    print(\\"HTTP POST 请求失败！\\")\\n    print(\\"响应状态码:\\", response.status_code)"
}', '["image"]', 1, 2, 1800, '', '{"openapi":"3.0.2","info":{"title":"Cog","version":"0.1.0"},"paths":{"/":{"get":{"summary":"Root","operationId":"root__get","responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"title":"Response Root  Get"}}}}}}},"/health-check":{"get":{"summary":"Healthcheck","operationId":"healthcheck_health_check_get","responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"title":"Response Healthcheck Health Check Get"}}}}}}},"/predictions":{"post":{"summary":"Predict","description":"Run a single prediction on the model","operationId":"predict_predictions_post","parameters":[{"required":false,"schema":{"title":"Prefer","type":"string"},"name":"prefer","in":"header"}],"requestBody":{"content":{"application/json":{"schema":{"$ref":"#/components/schemas/PredictionRequest"}}}},"responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"$ref":"#/components/schemas/PredictionResponse"}}}},"422":{"description":"Validation Error","content":{"application/json":{"schema":{"$ref":"#/components/schemas/HTTPValidationError"}}}}}}},"/predictions/{prediction_id}":{"put":{"summary":"Predict Idempotent","description":"Run a single prediction on the model (idempotent creation).","operationId":"predict_idempotent_predictions__prediction_id__put","parameters":[{"required":true,"schema":{"title":"Prediction ID","type":"string"},"name":"prediction_id","in":"path"},{"required":false,"schema":{"title":"Prefer","type":"string"},"name":"prefer","in":"header"}],"requestBody":{"content":{"application/json":{"schema":{"title":"Prediction Request","allOf":[{"$ref":"#/components/schemas/PredictionRequest"}]}}},"required":true},"responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"$ref":"#/components/schemas/PredictionResponse"}}}},"422":{"description":"Validation Error","content":{"application/json":{"schema":{"$ref":"#/components/schemas/HTTPValidationError"}}}}}}},"/predictions/{prediction_id}/cancel":{"post":{"summary":"Cancel","description":"Cancel a running prediction","operationId":"cancel_predictions__prediction_id__cancel_post","parameters":[{"required":true,"schema":{"title":"Prediction ID","type":"string"},"name":"prediction_id","in":"path"}],"responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"title":"Response Cancel Predictions  Prediction Id  Cancel Post"}}}},"422":{"description":"Validation Error","content":{"application/json":{"schema":{"$ref":"#/components/schemas/HTTPValidationError"}}}}}}},"/shutdown":{"post":{"summary":"Start Shutdown","operationId":"start_shutdown_shutdown_post","responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"title":"Response Start Shutdown Shutdown Post"}}}}}}}},"components":{"schemas":{"HTTPValidationError":{"title":"HTTPValidationError","type":"object","properties":{"detail":{"title":"Detail","type":"array","items":{"$ref":"#/components/schemas/ValidationError"}}}},"Input":{"title":"Input","type":"object","properties":{"prompt":{"title":"Prompt","type":"string","description":"Input prompt","default":"An astronaut riding a rainbow unicorn","x-order":0},"negative_prompt":{"title":"Negative Prompt","type":"string","description":"Input Negative Prompt","default":"","x-order":1},"image":{"title":"Image","type":"string","description":"Input image for img2img or inpaint mode","format":"uri","x-order":2},"mask":{"title":"Mask","type":"string","description":"Input mask for inpaint mode. Black areas will be preserved, white areas will be inpainted.","format":"uri","x-order":3},"width":{"title":"Width","type":"integer","description":"Width of output image","default":1024,"x-order":4},"height":{"title":"Height","type":"integer","description":"Height of output image","default":1024,"x-order":5},"num_outputs":{"title":"Num Outputs","maximum":4.0,"minimum":1.0,"type":"integer","description":"Number of images to output.","default":1,"x-order":6},"scheduler":{"allOf":[{"$ref":"#/components/schemas/scheduler"}],"description":"scheduler","default":"K_EULER","x-order":7},"num_inference_steps":{"title":"Num Inference Steps","maximum":500.0,"minimum":1.0,"type":"integer","description":"Number of denoising steps","default":50,"x-order":8},"guidance_scale":{"title":"Guidance Scale","maximum":50.0,"minimum":1.0,"type":"number","description":"Scale for classifier-free guidance","default":7.5,"x-order":9},"prompt_strength":{"title":"Prompt Strength","maximum":1.0,"minimum":0.0,"type":"number","description":"Prompt strength when using img2img / inpaint. 1.0 corresponds to full destruction of information in image","default":0.8,"x-order":10},"seed":{"title":"Seed","type":"integer","description":"Random seed. Leave blank to randomize the seed","x-order":11},"refine":{"allOf":[{"$ref":"#/components/schemas/refine"}],"description":"Which refine style to use","default":"no_refiner","x-order":12},"high_noise_frac":{"title":"High Noise Frac","maximum":1.0,"minimum":0.0,"type":"number","description":"For expert_ensemble_refiner, the fraction of noise to use","default":0.8,"x-order":13},"refine_steps":{"title":"Refine Steps","type":"integer","description":"For base_image_refiner, the number of steps to refine, defaults to num_inference_steps","x-order":14},"apply_watermark":{"title":"Apply Watermark","type":"boolean","description":"Applies a watermark to enable determining if an image is generated in downstream applications. If you have other provisions for generating or deploying images safely, you can use this to disable watermarking.","default":true,"x-order":15},"lora_scale":{"title":"Lora Scale","maximum":1.0,"minimum":0.0,"type":"number","description":"LoRA additive scale. Only applicable on trained models.","default":0.6,"x-order":16},"replicate_weights":{"title":"Replicate Weights","type":"string","description":"Replicate LoRA weights to use. Leave blank to use the default weights.","x-order":17},"disable_safety_checker":{"title":"Disable Safety Checker","type":"boolean","description":"Disable safety checker for generated images. This feature is only available through the API. See https://replicate.com/docs/how-does-replicate-work#safety","default":false,"x-order":18}}},"Output":{"title":"Output","type":"array","items":{"type":"string","format":"uri"}},"PredictionRequest":{"title":"PredictionRequest","type":"object","properties":{"input":{"$ref":"#/components/schemas/Input"},"id":{"title":"Id","type":"string"},"created_at":{"title":"Created At","type":"string","format":"date-time"},"output_file_prefix":{"title":"Output File Prefix","type":"string"},"webhook":{"title":"Webhook","maxLength":65536,"minLength":1,"type":"string","format":"uri"},"webhook_events_filter":{"type":"array","items":{"$ref":"#/components/schemas/WebhookEvent"},"default":["start","output","logs","completed"]}}},"PredictionResponse":{"title":"PredictionResponse","type":"object","properties":{"input":{"$ref":"#/components/schemas/Input"},"output":{"$ref":"#/components/schemas/Output"},"id":{"title":"Id","type":"string"},"version":{"title":"Version","type":"string"},"created_at":{"title":"Created At","type":"string","format":"date-time"},"started_at":{"title":"Started At","type":"string","format":"date-time"},"completed_at":{"title":"Completed At","type":"string","format":"date-time"},"logs":{"title":"Logs","type":"string","default":""},"error":{"title":"Error","type":"string"},"status":{"$ref":"#/components/schemas/Status"},"metrics":{"title":"Metrics","type":"object"}}},"Status":{"title":"Status","enum":["starting","processing","succeeded","canceled","failed"],"type":"string","description":"An enumeration."},"ValidationError":{"title":"ValidationError","required":["loc","msg","type"],"type":"object","properties":{"loc":{"title":"Location","type":"array","items":{"anyOf":[{"type":"string"},{"type":"integer"}]}},"msg":{"title":"Message","type":"string"},"type":{"title":"Error Type","type":"string"}}},"WebhookEvent":{"title":"WebhookEvent","enum":["start","output","logs","completed"],"type":"string","description":"An enumeration."},"refine":{"title":"refine","enum":["no_refiner","expert_ensemble_refiner","base_image_refiner"],"type":"string","description":"An enumeration."},"scheduler":{"title":"scheduler","enum":["DDIM","DPMSolverMultistep","HeunDiscrete","KarrasDPM","K_EULER_ANCESTRAL","K_EULER","PNDM"],"type":"string","description":"An enumeration."}}}}
', 1, 1, '2024-03-08 18:42:26', '2024-03-08 18:42:26', 0),
        (18, 'stable-diffusion-inpainting', 'Fill in masked parts of images with Stable Diffusion', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/stability-ai/stable-diffusion-inpainting:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/stability-ai/stable-diffusion-inpainting:latest"}', 100, '/predictions/stability-ai/stable-diffusion-inpainting', 8, 'stable-diffusion-inpainting', 'base', '[{"title":"cat","input":{
        "mask": "https://replicate.delivery/pbxt/HtGQBqO9MtVbPm0G0K43nsvvjBB0E0PaWOhuNRrRBBT4ttbf/mask.png",
        "image": "https://replicate.delivery/pbxt/HtGQBfA5TrqFYZBf0UL18NTqHrzt8UiSIsAkUuMHtjvFDO6p/overture-creations-5sI6fQgYIuo.png",
        "width": 512,
        "height": 512,
        "prompt": "Face of a yellow cat, high resolution, sitting on a park bench",
        "scheduler": "DPMSolverMultistep",
        "num_outputs": 1,
        "guidance_scale": 7.5,
        "num_inference_steps": 25
    },"output": [
    "https://replicate.delivery/pbxt/xs0pPOUM6HKmPlJJBXqKfE1YsiMzgNsCuGedlX0VqvPYifLgA/out-0.png"
 ]}]', '', '', '{
    "javascript": "const axios = require(''axios'');\\n\\n// 替换成你的 API 密钥和 API URL\\nconst API_KEY = $API_KEY;\\nconst API_URL = $END_POINT + $API_PATH;\\nconst data = {\\"input\\":$INPUT}\\n\\n// 设置请求头，包含 API 密钥\\nconst headers = {\\n    ''apikey'': API_KEY,\\n    ''Content-Type'': ''application/json''\\n};\\n\\n// 发送 GET 请求\\naxios.get(API_URL, { headers })\\n    .then(response => {\\n        // 打印返回的 JSON 数据\\n        console.log(''Response:'', response.data);\\n    })\\n    .catch(error => {\\n        // 处理错误\\n        console.error(''Error:'', error);\\n    });",
    "python": "# 定义请求的 URL 和要发送的数据\\nurl = $END_POINT + $API_PATH\\ndata = {\\"input\\":$INPUT}\\n\\n# 定义 API Key\\napi_key = $API_KEY\\n\\n# 设置请求头\\nheaders = {apikey'': api_key}\\n# 发送 POST 请求\\nresponse = requests.post(url, data=data, headers=headers)\\n\\n# 检查响应\\nif response.status_code == 200:\\n    print(\\"HTTP POST 请求成功！\\")\\n    # 打印\\nprint(response.content)\\nelse:\\n    print(\\"HTTP POST 请求失败！\\")\\n    print(\\"响应状态码:\\", response.status_code)"
}', '["image"]', 1, 2, 1800, '', '{"openapi":"3.0.2","info":{"title":"Cog","version":"0.1.0"},"paths":{"/shutdown":{"post":{"summary":"Start Shutdown","operationId":"start_shutdown_shutdown_post","responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"title":"Response Start Shutdown Shutdown Post"}}}}}}},"/":{"get":{"summary":"Root","operationId":"root__get","responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"title":"Response Root  Get"}}}}}}},"/health-check":{"get":{"summary":"Healthcheck","operationId":"healthcheck_health_check_get","responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"title":"Response Healthcheck Health Check Get"}}}}}}},"/predictions":{"post":{"summary":"Predict","description":"Run a single prediction on the model","operationId":"predict_predictions_post","parameters":[{"required":false,"schema":{"title":"Prefer","type":"string"},"name":"prefer","in":"header"}],"requestBody":{"content":{"application/json":{"schema":{"$ref":"#/components/schemas/PredictionRequest"}}}},"responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"$ref":"#/components/schemas/PredictionResponse"}}}},"422":{"description":"Validation Error","content":{"application/json":{"schema":{"$ref":"#/components/schemas/HTTPValidationError"}}}}}}},"/predictions/{prediction_id}":{"put":{"summary":"Predict Idempotent","description":"Run a single prediction on the model (idempotent creation).","operationId":"predict_idempotent_predictions__prediction_id__put","parameters":[{"required":true,"schema":{"title":"Prediction ID","type":"string"},"name":"prediction_id","in":"path"},{"required":false,"schema":{"title":"Prefer","type":"string"},"name":"prefer","in":"header"}],"requestBody":{"content":{"application/json":{"schema":{"title":"Prediction Request","allOf":[{"$ref":"#/components/schemas/PredictionRequest"}]}}},"required":true},"responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"$ref":"#/components/schemas/PredictionResponse"}}}},"422":{"description":"Validation Error","content":{"application/json":{"schema":{"$ref":"#/components/schemas/HTTPValidationError"}}}}}}},"/predictions/{prediction_id}/cancel":{"post":{"summary":"Cancel","description":"Cancel a running prediction","operationId":"cancel_predictions__prediction_id__cancel_post","parameters":[{"required":true,"schema":{"title":"Prediction ID","type":"string"},"name":"prediction_id","in":"path"}],"responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"title":"Response Cancel Predictions  Prediction Id  Cancel Post"}}}},"422":{"description":"Validation Error","content":{"application/json":{"schema":{"$ref":"#/components/schemas/HTTPValidationError"}}}}}}}},"components":{"schemas":{"HTTPValidationError":{"title":"HTTPValidationError","type":"object","properties":{"detail":{"title":"Detail","type":"array","items":{"$ref":"#/components/schemas/ValidationError"}}}},"Input":{"title":"Input","required":["image","mask"],"type":"object","properties":{"prompt":{"title":"Prompt","type":"string","description":"Input prompt","default":"a vision of paradise. unreal engine","x-order":0},"image":{"title":"Image","type":"string","description":"Initial image to generate variations of. Will be resized to height x width","format":"uri","x-order":1},"mask":{"title":"Mask","type":"string","description":"Black and white image to use as mask for inpainting over the image provided. White pixels are inpainted and black pixels are preserved.","format":"uri","x-order":2},"height":{"allOf":[{"$ref":"#/components/schemas/height"}],"description":"Height of generated image in pixels. Needs to be a multiple of 64","default":512,"x-order":3},"width":{"allOf":[{"$ref":"#/components/schemas/width"}],"description":"Width of generated image in pixels. Needs to be a multiple of 64","default":512,"x-order":4},"negative_prompt":{"title":"Negative Prompt","type":"string","description":"Specify things to not see in the output","x-order":5},"num_outputs":{"title":"Num Outputs","maximum":4.0,"minimum":1.0,"type":"integer","description":"Number of images to generate.","default":1,"x-order":6},"num_inference_steps":{"title":"Num Inference Steps","maximum":500.0,"minimum":1.0,"type":"integer","description":"Number of denoising steps","default":50,"x-order":7},"guidance_scale":{"title":"Guidance Scale","maximum":20.0,"minimum":1.0,"type":"number","description":"Scale for classifier-free guidance","default":7.5,"x-order":8},"scheduler":{"allOf":[{"$ref":"#/components/schemas/scheduler"}],"description":"Choose a scheduler.","default":"DPMSolverMultistep","x-order":9},"seed":{"title":"Seed","type":"integer","description":"Random seed. Leave blank to randomize the seed","x-order":10},"disable_safety_checker":{"title":"Disable Safety Checker","type":"boolean","description":"Disable safety checker for generated images. This feature is only available through the API. See [https://replicate.com/docs/how-does-replicate-work#safety](https://replicate.com/docs/how-does-replicate-work#safety)","default":false,"x-order":11}}},"Output":{"title":"Output","type":"array","items":{"type":"string","format":"uri"}},"PredictionRequest":{"title":"PredictionRequest","type":"object","properties":{"input":{"$ref":"#/components/schemas/Input"},"id":{"title":"Id","type":"string"},"created_at":{"title":"Created At","type":"string","format":"date-time"},"output_file_prefix":{"title":"Output File Prefix","type":"string"},"webhook":{"title":"Webhook","maxLength":65536,"minLength":1,"type":"string","format":"uri"},"webhook_events_filter":{"type":"array","items":{"$ref":"#/components/schemas/WebhookEvent"},"default":["start","output","logs","completed"]}}},"PredictionResponse":{"title":"PredictionResponse","type":"object","properties":{"input":{"$ref":"#/components/schemas/Input"},"output":{"$ref":"#/components/schemas/Output"},"id":{"title":"Id","type":"string"},"version":{"title":"Version","type":"string"},"created_at":{"title":"Created At","type":"string","format":"date-time"},"started_at":{"title":"Started At","type":"string","format":"date-time"},"completed_at":{"title":"Completed At","type":"string","format":"date-time"},"logs":{"title":"Logs","type":"string","default":""},"error":{"title":"Error","type":"string"},"status":{"$ref":"#/components/schemas/Status"},"metrics":{"title":"Metrics","type":"object"}}},"Status":{"title":"Status","enum":["starting","processing","succeeded","canceled","failed"],"type":"string","description":"An enumeration."},"ValidationError":{"title":"ValidationError","required":["loc","msg","type"],"type":"object","properties":{"loc":{"title":"Location","type":"array","items":{"anyOf":[{"type":"string"},{"type":"integer"}]}},"msg":{"title":"Message","type":"string"},"type":{"title":"Error Type","type":"string"}}},"WebhookEvent":{"title":"WebhookEvent","enum":["start","output","logs","completed"],"type":"string","description":"An enumeration."},"height":{"title":"height","enum":[64,128,192,256,320,384,448,512,576,640,704,768,832,896,960,1024],"type":"integer","description":"An enumeration."},"scheduler":{"title":"scheduler","enum":["DDIM","K_EULER","DPMSolverMultistep","K_EULER_ANCESTRAL","PNDM","KLMS"],"type":"string","description":"An enumeration."},"width":{"title":"width","enum":[64,128,192,256,320,384,448,512,576,640,704,768,832,896,960,1024],"type":"integer","description":"An enumeration."}}}}
', 1, 1, '2024-03-08 18:42:30', '2024-03-08 18:42:30', 0),
        (19, 'kandinsky-2.2', 'multilingual text2image latent diffusion model', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/ai-forever/kandinsky-2.2:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/ai-forever/kandinsky-2.2:latest"}', 100, '/predictions/ai-forever/kandinsky-2.2', 1, 'kandinsky-2.2', 'base', '[{"title":"astronaut","input": {
        "width": 1024,
        "height": 1024,
        "prompt": "A moss covered astronaut with a black background",
        "num_outputs": 1,
        "num_inference_steps": 75,
        "num_inference_steps_prior": 25
    },"output":[
    "https://replicate.delivery/pbxt/Lca3IEjcKoJBBVS6ajROkK37sDzPsmjYxIcFzxPZp65wZzTE/out-0.png"
  ]},
  {"title":"woman","input":{
    "width": "896",
    "height": 1024,
    "prompt": "Detailed portrait of a masked woman, bright peacock feathers, complex, elegant, highly detailed, digital painting, art, fluid, illustration, green highlighted lines, complex patterns, cyberpunk Alphonse Mucha",
    "num_outputs": 1,
    "negative_prompt": "",
    "num_inference_steps": 150
  },"output": [
    "https://replicate.delivery/pbxt/2QC5sev3eFg2lUPZrYokF1FYCIGF9YC2BlFtExvMxXKef38EB/out-0.png"
  ]}]', '', '', '{
    "javascript": "const axios = require(''axios'');\\n\\n// 替换成你的 API 密钥和 API URL\\nconst API_KEY = $API_KEY;\\nconst API_URL = $END_POINT + $API_PATH;\\nconst data = {\\"input\\":$INPUT}\\n\\n// 设置请求头，包含 API 密钥\\nconst headers = {\\n    ''apikey'': API_KEY,\\n    ''Content-Type'': ''application/json''\\n};\\n\\n// 发送 GET 请求\\naxios.get(API_URL, { headers })\\n    .then(response => {\\n        // 打印返回的 JSON 数据\\n        console.log(''Response:'', response.data);\\n    })\\n    .catch(error => {\\n        // 处理错误\\n        console.error(''Error:'', error);\\n    });",
    "python": "# 定义请求的 URL 和要发送的数据\\nurl = $END_POINT + $API_PATH\\ndata = {\\"input\\":$INPUT}\\n\\n# 定义 API Key\\napi_key = $API_KEY\\n\\n# 设置请求头\\nheaders = {apikey'': api_key}\\n# 发送 POST 请求\\nresponse = requests.post(url, data=data, headers=headers)\\n\\n# 检查响应\\nif response.status_code == 200:\\n    print(\\"HTTP POST 请求成功！\\")\\n    # 打印\\nprint(response.content)\\nelse:\\n    print(\\"HTTP POST 请求失败！\\")\\n    print(\\"响应状态码:\\", response.status_code)"
}', '["image"]', 1, 2, 1800, '', '{"openapi":"3.0.2","info":{"title":"Cog","version":"0.1.0"},"paths":{"/":{"get":{"summary":"Root","operationId":"root__get","responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"title":"Response Root  Get"}}}}}}},"/health-check":{"get":{"summary":"Healthcheck","operationId":"healthcheck_health_check_get","responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"title":"Response Healthcheck Health Check Get"}}}}}}},"/predictions":{"post":{"summary":"Predict","description":"Run a single prediction on the model","operationId":"predict_predictions_post","parameters":[{"required":false,"schema":{"title":"Prefer","type":"string"},"name":"prefer","in":"header"}],"requestBody":{"content":{"application/json":{"schema":{"$ref":"#/components/schemas/PredictionRequest"}}}},"responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"$ref":"#/components/schemas/PredictionResponse"}}}},"422":{"description":"Validation Error","content":{"application/json":{"schema":{"$ref":"#/components/schemas/HTTPValidationError"}}}}}}},"/predictions/{prediction_id}":{"put":{"summary":"Predict Idempotent","description":"Run a single prediction on the model (idempotent creation).","operationId":"predict_idempotent_predictions__prediction_id__put","parameters":[{"required":true,"schema":{"title":"Prediction ID","type":"string"},"name":"prediction_id","in":"path"},{"required":false,"schema":{"title":"Prefer","type":"string"},"name":"prefer","in":"header"}],"requestBody":{"content":{"application/json":{"schema":{"title":"Prediction Request","allOf":[{"$ref":"#/components/schemas/PredictionRequest"}]}}},"required":true},"responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"$ref":"#/components/schemas/PredictionResponse"}}}},"422":{"description":"Validation Error","content":{"application/json":{"schema":{"$ref":"#/components/schemas/HTTPValidationError"}}}}}}},"/predictions/{prediction_id}/cancel":{"post":{"summary":"Cancel","description":"Cancel a running prediction","operationId":"cancel_predictions__prediction_id__cancel_post","parameters":[{"required":true,"schema":{"title":"Prediction ID","type":"string"},"name":"prediction_id","in":"path"}],"responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"title":"Response Cancel Predictions  Prediction Id  Cancel Post"}}}},"422":{"description":"Validation Error","content":{"application/json":{"schema":{"$ref":"#/components/schemas/HTTPValidationError"}}}}}}},"/shutdown":{"post":{"summary":"Start Shutdown","operationId":"start_shutdown_shutdown_post","responses":{"200":{"description":"Successful Response","content":{"application/json":{"schema":{"title":"Response Start Shutdown Shutdown Post"}}}}}}}},"components":{"schemas":{"HTTPValidationError":{"title":"HTTPValidationError","type":"object","properties":{"detail":{"title":"Detail","type":"array","items":{"$ref":"#/components/schemas/ValidationError"}}}},"Input":{"title":"Input","type":"object","properties":{"prompt":{"title":"Prompt","type":"string","description":"Input prompt","default":"A moss covered astronaut with a black background","x-order":0},"negative_prompt":{"title":"Negative Prompt","type":"string","description":"Specify things to not see in the output","x-order":1},"width":{"allOf":[{"$ref":"#/components/schemas/width"}],"description":"Width of output image. Lower the setting if hits memory limits.","default":512,"x-order":2},"height":{"allOf":[{"$ref":"#/components/schemas/height"}],"description":"Height of output image. Lower the setting if hits memory limits.","default":512,"x-order":3},"num_inference_steps":{"title":"Num Inference Steps","maximum":500.0,"minimum":1.0,"type":"integer","description":"Number of denoising steps","default":75,"x-order":4},"num_inference_steps_prior":{"title":"Num Inference Steps Prior","maximum":500.0,"minimum":1.0,"type":"integer","description":"Number of denoising steps for priors","default":25,"x-order":5},"num_outputs":{"title":"Num Outputs","maximum":4.0,"minimum":1.0,"type":"integer","description":"Number of images to output.","default":1,"x-order":6},"seed":{"title":"Seed","type":"integer","description":"Random seed. Leave blank to randomize the seed","x-order":7}}},"Output":{"title":"Output","type":"array","items":{"type":"string","format":"uri"}},"PredictionRequest":{"title":"PredictionRequest","type":"object","properties":{"input":{"$ref":"#/components/schemas/Input"},"id":{"title":"Id","type":"string"},"created_at":{"title":"Created At","type":"string","format":"date-time"},"output_file_prefix":{"title":"Output File Prefix","type":"string"},"webhook":{"title":"Webhook","maxLength":65536,"minLength":1,"type":"string","format":"uri"},"webhook_events_filter":{"uniqueItems":true,"type":"array","items":{"$ref":"#/components/schemas/WebhookEvent"},"default":["logs","output","completed","start"]}}},"PredictionResponse":{"title":"PredictionResponse","type":"object","properties":{"input":{"$ref":"#/components/schemas/Input"},"output":{"$ref":"#/components/schemas/Output"},"id":{"title":"Id","type":"string"},"version":{"title":"Version","type":"string"},"created_at":{"title":"Created At","type":"string","format":"date-time"},"started_at":{"title":"Started At","type":"string","format":"date-time"},"completed_at":{"title":"Completed At","type":"string","format":"date-time"},"logs":{"title":"Logs","type":"string","default":""},"error":{"title":"Error","type":"string"},"status":{"$ref":"#/components/schemas/Status"},"metrics":{"title":"Metrics","type":"object"}}},"Status":{"title":"Status","enum":["starting","processing","succeeded","canceled","failed"],"type":"string","description":"An enumeration."},"ValidationError":{"title":"ValidationError","required":["loc","msg","type"],"type":"object","properties":{"loc":{"title":"Location","type":"array","items":{"anyOf":[{"type":"string"},{"type":"integer"}]}},"msg":{"title":"Message","type":"string"},"type":{"title":"Error Type","type":"string"}}},"WebhookEvent":{"title":"WebhookEvent","enum":["start","output","logs","completed"],"type":"string","description":"An enumeration."},"height":{"title":"height","enum":[384,512,576,640,704,768,960,1024,1152,1280,1536,1792,2048],"type":"integer","description":"An enumeration."},"width":{"title":"width","enum":[384,512,576,640,704,768,960,1024,1152,1280,1536,1792,2048],"type":"integer","description":"An enumeration."}}}}
', 1, 1, '2024-03-08 18:42:34', '2024-03-08 18:42:34', 0),
        (20, 'kandinsky-2', 'text2img model trained on LAION HighRes and fine-tuned on internal datasets', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/ai-forever/kandinsky-2:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/ai-forever/kandinsky-2:latest"}', 100, '/predictions/ai-forever/kandinsky-2', 1, 'kandinsky-2', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 03:35:28', '2024-03-06 03:35:28', 0),
        (21, 'sdxl-emoji', 'An SDXL fine-tune based on Apple Emojis', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/fofr/sdxl-emoji:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/fofr/sdxl-emoji:latest"}', 100, '/predictions/fofr/sdxl-emoji', 1, 'sdxl-emoji', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 03:39:46', '2024-03-06 03:39:46', 0),
        (22, 'material-diffusion', 'Stable diffusion fork for generating tileable outputs using v1.5 model', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/tstramer/material-diffusion:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/tstramer/material-diffusion:latest"}', 100, '/predictions/tstramer/material-diffusion', 1, 'Stable-diffusion', 'material-diffusion', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 03:44:36', '2024-03-06 03:44:36', 0),
        (23, 'ssd-1b', 'Segmind Stable Diffusion Model (SSD-1B) is a distilled 50% smaller version of SDXL, offering a 60% speedup while maintaining high-quality text-to-image generation capabilities', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/lucataco/ssd-1b:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/lucataco/ssd-1b:latest"}', 100, '/predictions/lucataco/ssd-1b', 1, 'Stable-Diffusion', 'ssd-1b', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 03:48:22', '2024-03-06 03:48:22', 0),
        (24, 'latent-consistency-model', 'Super-fast, 0.6s per image. LCM with img2img, large batching and canny controlnet', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/fofr/latent-consistency-model:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/fofr/latent-consistency-model:latest"}', 100, '/predictionsfofr/latent-consistency-model', 8, 'latent-consistency-model', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 03:52:23', '2024-03-06 03:52:23', 0),
        (25, 'sdxl-controlnet-lora', '''''''Last update: Now supports img2img.'''''' SDXL Canny controlnet with LoRA support.', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/batouresearch/sdxl-controlnet-lora:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/batouresearch/sdxl-controlnet-lora:latest"}', 100, '/predictions/batouresearch/sdxl-controlnet-lora', 1, 'sdxl-controlnet-lora', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 06:54:05', '2024-03-06 06:54:05', 0),
        (26, 'realvisxl-v2.0', 'Implementation of SDXL RealVisXL_V2.0', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/lucataco/realvisxl-v2.0:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/lucataco/realvisxl-v2.0:latest"}', 100, '/predictions/lucataco/realvisxl-v2.0', 1, 'SDXL', 'realvisxl-v2.0', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 06:54:17', '2024-03-06 06:54:17', 0),
        (27, 'playground-v2-1024px-aesthetic', 'Playground v2 is a diffusion-based text-to-image generative model trained from scratch by the research team at Playground', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/playgroundai/playground-v2-1024px-aesthetic:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/playgroundai/playground-v2-1024px-aesthetic:latest"}', 100, '/predictions/playgroundai/playground-v2-1024px-aesthetic', 1, 'playground-v2-1024px-aesthetic', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 06:54:31', '2024-03-06 06:54:31', 0),
        (28, 'realvisxl2-lcm', 'RealvisXL-v2.0 with LCM LoRA - requires fewer steps (4 to 8 instead of the original 40 to 50)', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/lucataco/realvisxl2-lcm:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/lucataco/realvisxl2-lcm:latest"}', 100, '/predictions/lucataco/realvisxl2-lcm', 1, 'realvisxl2-lcm', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 06:54:39', '2024-03-06 06:54:39', 0),
        (29, 'sdxl-lightning-4step', 'SDXL-Lightning by ByteDance, is a fast text-to-image model that makes high-quality images in 4 steps', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/lucataco/sdxl-lightning-4step:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/lucataco/sdxl-lightning-4step:latest"}', 100, '/predictions/lucataco/sdxl-lightning-4step', 1, 'sdxl', 'lucataco/sdxl-lightning-4step', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 06:54:47', '2024-03-06 06:54:47', 0),
        (30, 'proteus-v0.2', 'Proteus v0.2 shows subtle yet significant improvements over Version 0.1. It demonstrates enhanced prompt understanding that surpasses MJ6, while also approaching its stylistic capabilities.', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/lucataco/proteus-v0.2:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/lucataco/proteus-v0.2:latest"}', 100, 'lucataco/proteus-v0.2', 1, 'proteus-v0.2', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 06:54:57', '2024-03-06 06:54:57', 0),
        (31, 'sdxl-multi-controlnet-lora', 'Multi-controlnet, lora loading, img2img, inpainting', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/fofr/sdxl-multi-controlnet-lora:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/fofr/sdxl-multi-controlnet-lora:latest"}', 100, 'fofr/sdxl-multi-controlnet-lora', 1, 'sdxl', 'sdxl-multi-controlnet-lora', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 06:55:05', '2024-03-06 06:55:05', 0),
        (32, 'realvisxl-v3-multi-controlnet-lora', 'RealVisXl V3 with multi-controlnet, lora loading, img2img, inpainting', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/fofr/realvisxl-v3-multi-controlnet-lora:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/fofr/realvisxl-v3-multi-controlnet-lora:latest"}', 100, '/predictions/fofr/realvisxl-v3-multi-controlnet-lora', 1, 'realvisxl-v3', 'realvisxl-v3-multi-controlnet-lora', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 06:53:52', '2024-03-06 06:53:52', 0),
        (33, 'kandinsky-2-1', 'Kandinsky 2.1 Diffusion Model', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/ai-forever/kandinsky-2-1:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/ai-forever/kandinsky-2-1:latest"}', 100, '/predictions/ai-forever/kandinsky-2-1', 1, 'kandinsky-2-1', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 06:56:57', '2024-03-06 06:56:57', 0),
        (34, 'dreamshaper-xl-turbo', 'DreamShaper is a general purpose SD model that aims at doing everything well, photos, art, anime, manga. It''s designed to match Midjourney and DALL-E.', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/lucataco/dreamshaper-xl-turbo:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/lucataco/dreamshaper-xl-turbo:latest"}', 100, '/predictions/lucataco/dreamshaper-xl-turbo', 1, 'dreamshaper-xl-turbo', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 06:59:16', '2024-03-06 06:59:16', 0),
        (35, 'open-dalle-v1.1', 'A unique fusion that showcases exceptional prompt adherence and semantic understanding, it seems to be a step above base SDXL and a step closer to DALLE-3 in terms of prompt comprehension', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/lucataco/open-dalle-v1.1:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/lucataco/open-dalle-v1.1:latest"}', 100, '/predictions/lucataco/open-dalle-v1.1', 1, 'SDXL', 'open-dalle-v1.1', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 07:01:59', '2024-03-06 07:01:59', 0),
        (36, 'disco-diffusion', 'Generate images using a variety of techniques ', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/nightmareai/disco-diffusion:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/nightmareai/disco-diffusion:latest"}', 100, '/predictions/nightmareai/disco-diffusion', 1, 'disco-diffusion', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 07:03:49', '2024-03-06 07:03:49', 0),
        (37, 'any-comfyui-workflow', 'Run any ComfyUI workflow.', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/fofr/any-comfyui-workflow:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/fofr/any-comfyui-workflow:latest"}', 100, '/predictions/fofr/any-comfyui-workflow', 1, 'any-comfyui-workflow', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 07:06:09', '2024-03-06 07:06:09', 0),
        (38, 'pixart-xl-2', 'PixArt-Alpha 1024px is a transformer-based text-to-image diffusion system trained on text embeddings from T5', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/lucataco/pixart-xl-2:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/lucataco/pixart-xl-2:latest"}', 100, '/predictions/lucataco/pixart-xl-2', 1, 'pixart-xl-2', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 07:08:30', '2024-03-06 07:08:30', 0),
        (39, 'realvisxl-v3.0-turbo', 'Photorealism with RealVisXL V3.0 Turbo based on SDXL', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/adirik/realvisxl-v3.0-turbo:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/adirik/realvisxl-v3.0-turbo:latest"}', 100, '/predictions/adirik/realvisxl-v3.0-turbo', 1, 'SDXL', 'realvisxl-v3.0-turbo', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 07:10:10', '2024-03-06 07:10:10', 0),
        (40, 'thinkdiffusionxl', 'ThinkDiffusionXL is a go-to model capable of amazing photorealism that''s also versatile enough to generate high-quality images across a variety of styles and subjects without needing to be a prompting genius', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/lucataco/thinkdiffusionxl:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/lucataco/thinkdiffusionxl:latest"}', 100, '/predictions/lucataco/thinkdiffusionxl', 1, 'thinkdiffusionxl', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 07:12:17', '2024-03-06 07:12:17', 0),
        (41, 'playground-v2.5-1024px-aesthetic', 'State-of-the-art text to image', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"1000","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/lucataco/playground-v2.5-1024px-aesthetic:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/lucataco/playground-v2.5-1024px-aesthetic:latest"}', 100, '/predictions/lucataco/playground-v2.5-1024px-aesthetic', 1, 'playground-v2.5-1024px-aesthetic', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 07:14:15', '2024-03-06 07:14:15', 0),
        (42, 'proteus-v0.3', 'ProteusV0.3: The Anime Update', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/lucataco/proteus-v0.3:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/lucataco/proteus-v0.3:latest"}', 100, '/predictions/lucataco/proteus-v0.3', 1, 'proteus-v0.3', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-06 07:17:32', '2024-03-06 07:17:32', 0),
        (43, 'gfpgan', 'Practical face restoration algorithm for *old photos* or *AI-generated faces*', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/tencentarc/gfpgan:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/tencentarc/gfpgan:latest"}', 100, '/predictions/tencentarc/gfpgan', 6, 'gfpgan', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-07 07:20:51', '2024-03-07 07:20:51', 0),
        (44, 'codeformer', 'Robust face restoration algorithm for old photos / AI-generated faces', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/sczhou/codeformer:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/sczhou/codeformer:latest"}', 100, '/predictions/sczhou/codeformer', 6, 'codeformer', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-07 07:25:30', '2024-03-07 07:25:30', 0),
        (45, 'controlnet', 'Control diffusion models', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/rossjillian/controlnet:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/rossjillian/controlnet:latest"}', 100, '/predictions/rossjillian/controlnet', 8, 'controlnet', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-07 07:34:30', '2024-03-07 07:34:30', 0),
        (46, 'swinir', 'Image Restoration Using Swin Transformer', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/jingyunliang/swinir:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/jingyunliang/swinir:latest"}', 100, '/predictions/jingyunliang/swinir', 6, 'swinir', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-07 08:25:11', '2024-03-07 08:25:11', 0),
        (47, 'blip', 'Bootstrapping Language-Image Pre-training', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/salesforce/blip:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/salesforce/blip:latest"}', 100, '/predictions/salesforce/blip', 4, 'blip', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-07 08:27:03', '2024-03-07 08:27:03', 0),
        (48, 'blip-2', 'Answers questions about images', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/andreasjansson/blip-2:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/andreasjansson/blip-2:latest"}', 100, '/predictions/andreasjansson/blip-2', 4, 'blip', 'blip-2', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-07 08:29:14', '2024-03-07 08:29:14', 0),
        (49, 'llava-13b', 'Visual instruction tuning towards large language and vision models with GPT-4 level capabilities', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/yorickvp/llava-13b:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/yorickvp/llava-13b:latest"}', 100, '/predictions/yorickvp/llava-13b', 7, 'llava-13b', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-07 08:32:39', '2024-03-07 08:32:39', 0),
        (50, 'clip-features', 'Return CLIP features for the clip-vit-large-patch14 model', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/andreasjansson/clip-features:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/andreasjansson/clip-features:latest"}', 100, '/predictions/andreasjansson/clip-features', 2, 'clip-features', 'base', '', '', '', '', '', 1, 1, null, '', null, null, null, '2024-03-07 08:36:36', '2024-03-07 08:36:36', 0),
        (51, 'imagebind', 'A model for text, audio, and image embeddings in one space', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/daanelson/imagebind:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/daanelson/imagebind:latest"}', 100, '/predictions/daanelson/imagebind', 7, 'imagebind', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-07 08:40:02', '2024-03-07 08:40:02', 0),
        (52, 'all-mpnet-base-v2', 'This is a language model that can be used to obtain document embeddings suitable for downstream tasks like semantic search and clustering.', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/replicate/all-mpnet-base-v2:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/replicate/all-mpnet-base-v2:latest"}', 100, '/predictions/replicate/all-mpnet-base-v2', 2, 'all-mpnet-base-v2', 'base', '', '', '', '', '', 1, 1, null, '', null, null, null, '2024-03-07 08:42:11', '2024-03-07 08:42:11', 0),
        (53, 'real-esrgan', 'Real-ESRGAN with optional face correction and adjustable upscale', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/nightmareai/real-esrgan:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/nightmareai/real-esrgan:latest"}', 100, '/predictions/nightmareai/real-esrgan', 6, 'real-esrgan', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-07 08:46:03', '2024-03-07 08:46:03', 0),
        (54, 'swin2sr', '3 Million Runs! AI Photorealistic Image Super-Resolution and Restoration', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/mv-lab/swin2sr:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/mv-lab/swin2sr:latest"}', 100, '/predictions/mv-lab/swin2sr', 8, 'swin2sr', 'base', '', '', '', '', '', 1, 2, null, '', null, null, null, '2024-03-07 08:49:50', '2024-03-07 08:49:50', 0),
        (55, 'llama-2-70b-chat', 'A 70 billion parameter language model from Meta, fine tuned for chat completions', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/meta/llama-2-70b-chat:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/meta/llama-2-70b-chat:latest"}', 100, '/predictions/meta/llama-2-70b-chat', 2, 'llama-2', 'llama-2-70b-chat', '', '', '', '', '', 1, 1, null, '', null, null, null, '2024-03-07 08:54:34', '2024-03-07 08:54:34', 0),
        (56, 'llama-2-13b-chat', 'A 13 billion parameter language model from Meta, fine tuned for chat completions', 1000000, 0x303432333936356335643562346332666130336665303234636662636434313364623235653763343230623733626435646363623738666164613965323264343834386433323935326339313361653063646363373065666133383039346463343963303563366130636563376531373132353537303530646137643762643035610000, 0, '{"disk_size":"100","gpus":[{"gpu":"3090"}],"memory_size":"100"}', '', '', 'r8.im/meta/llama-2-13b-chat:latest', 'http://47.94.59.74:9022/llm/test/get/sign', '', '', '{"api_url":"/predictions","docker_cmd":{"container_port":5000},"image_name":"r8.im/meta/llama-2-13b-chat:latest"}', 100, '/predictions/meta/llama-2-13b-chat', 2, 'llama-2', 'llama-2-13b-chat', '', '', '', '', '', 1, 1, null, '', null, null, null, '2024-03-07 08:59:55', '2024-03-07 08:59:55', 0);

insert into user (id, name, phone, mail, chain_account, `type`, is_authed, register_from, register_from_desc, username, balance, level, custom_id, verifier_id, rate_limit_plugin_id, profile_image, role, created_time, updated_time, deleted)
values  (23, '哄哄', '', '', '0xe88882eabb73836B238566382328f4f099a5c52A', 0, 0, 0, 'wechat', 'ai_51256842', 0, 0, '23', 'oauth2|Wechat|ojkKpuCXmCq_C3bA1vwZb7U3xnu4', 'd285b575-e0cb-4b2b-8e07-e709a1627d53', 'https://thirdwx.qlogo.cn/mmopen/vi_32/Q3auHgzwzM78J2GWW5UrxSPgA4R2A5oWKUCSQwIcu1prPHWoTENM2kXSux5mOEn447MtfebIKbmy75WK0B5FMQ/132', 4, '2024-03-05 18:36:29', '2024-03-05 18:36:29', 0),
        (24, 'Alex Tung', '', 'metaverse1024@gmail.com', '0x887e0607aB09CBdA109C95Eb98f58a3698e28BB2', 0, 0, 0, 'google', 'ai_cf490158', 0, 0, '24', 'metaverse1024@gmail.com', 'd44fc7fd-a334-4992-b2c2-5bd3fd293c0e', 'https://lh3.googleusercontent.com/a/ACg8ocKinyeUd_jf3ulKmXHqbhR0TQ7J9FjGe5BrMMDKnMg=s96-c', 1, '2024-03-05 18:36:35', '2024-03-05 18:36:35', 0),
        (25, 'chao Da', '', 'adadachao@gmail.com', '0x5d3dAC3C963A1492F097694389f7C47722B8fb05', 0, 0, 0, 'google', 'ai_91c0c80b', 0, 0, '25', 'adadachao@gmail.com', '6a4c8ffb-5ab0-4cab-9df0-8ac604596bcd', 'https://lh3.googleusercontent.com/a/ACg8ocLEG7joP-Y0mx922iMwx6aIydXoW3x9eoggrNaKnocP=s96-c', 2, '2024-03-05 18:36:07', '2024-03-05 18:36:07', 0),
        (26, 'brent_company@163.com', '', 'brent_company@163.com', '0x3a6d88CE3B47587742B8F51a281229919fA31889', 0, 0, 0, 'github', 'ai_60935614', 110000000000, 0, '26', 'github|44489278', 'd6cc8215-ac2c-41ba-8cee-829a1610a4ca', 'https://avatars.githubusercontent.com/u/44489278?v=4', 1, '2024-03-05 18:36:02', '2024-03-09 09:28:26', 0),
        (27, 'wade', '', 'liwei_wade@icloud.com', '0x4B3e4C4Dc95997D34877d794B459651e92d06F85', 0, 0, 0, 'github', 'ai_ffbcf8d5', 0, 0, '27', 'github|49429891', '89df5285-5968-47dd-98ce-cd6e83d02da6', 'https://avatars.githubusercontent.com/u/49429891?v=4', 4, '2024-03-09 14:14:36', '2024-03-09 14:14:36', 0);

insert into user_level (id, `level`, `desc`, credit_quota, free_call_count_day, free_call_count_month, free_call_count_year, free_call_count_total, rate_limit_second, rate_limit_minute, rate_limit_hour, rate_limit_day, rate_limit_month, rate_limit_year, price, discounted_price, created_time, updated_time, deleted)
values  (3, 0, '等级0', 10000000, 100, 3000, 20000, 0, 10, null, null, null, null, null, null, null, '2024-02-02 09:34:43', '2024-02-02 09:34:43', 0);

insert into user_level_task_type (id, free_call_count_day, free_call_count_month, free_call_count_year, free_call_count_total, user_level, task_type_id, created_time, updated_time, deleted)
values  (11, 100, 3000, 20000, 0, 0, 12, '2024-02-02 11:47:23', '2024-02-02 11:47:23', 0),
        (12, 50, 2000, 15000, 0, 0, 13, '2024-02-23 02:43:59', '2024-02-23 02:43:59', 0),
        (13, 50, 1000, 5000, 0, 0, 14, '2024-02-23 02:49:24', '2024-02-23 02:49:24', 0),
        (14, 50, 2000, 15000, 0, 0, 15, '2024-03-05 07:50:49', '2024-03-05 07:50:49', 0),
        (15, 50, 2000, 15000, 0, 0, 16, '2024-03-05 09:12:03', '2024-03-05 09:12:03', 0),
        (16, 50, 2000, 15000, 0, 0, 17, '2024-03-05 09:29:02', '2024-03-05 09:29:02', 0),
        (17, 50, 2000, 15000, 0, 0, 18, '2024-03-06 02:19:17', '2024-03-06 02:19:17', 0),
        (18, 50, 2000, 15000, 0, 0, 19, '2024-03-06 02:31:36', '2024-03-06 02:31:36', 0),
        (19, 50, 2000, 15000, 0, 0, 20, '2024-03-06 03:35:28', '2024-03-06 03:35:28', 0),
        (20, 50, 2000, 15000, 0, 0, 21, '2024-03-06 03:39:46', '2024-03-06 03:39:46', 0),
        (21, 50, 2000, 15000, 0, 0, 22, '2024-03-06 03:44:36', '2024-03-06 03:44:36', 0),
        (22, 50, 2000, 15000, 0, 0, 23, '2024-03-06 03:48:22', '2024-03-06 03:48:22', 0),
        (23, 50, 2000, 15000, 0, 0, 24, '2024-03-06 03:52:23', '2024-03-06 03:52:23', 0),
        (24, 50, 2000, 15000, 0, 0, 25, '2024-03-06 06:16:27', '2024-03-06 06:16:27', 0),
        (25, 50, 2000, 15000, 0, 0, 26, '2024-03-06 06:40:27', '2024-03-06 06:40:27', 0),
        (26, 50, 2000, 15000, 0, 0, 27, '2024-03-06 06:42:52', '2024-03-06 06:42:52', 0),
        (27, 50, 2000, 15000, 0, 0, 28, '2024-03-06 06:45:00', '2024-03-06 06:45:00', 0),
        (28, 50, 2000, 15000, 0, 0, 29, '2024-03-06 06:46:52', '2024-03-06 06:46:52', 0),
        (29, 50, 2000, 15000, 0, 0, 30, '2024-03-06 06:50:00', '2024-03-06 06:50:00', 0),
        (30, 50, 2000, 15000, 0, 0, 31, '2024-03-06 06:51:52', '2024-03-06 06:51:52', 0),
        (31, 50, 2000, 15000, 0, 0, 32, '2024-03-06 06:53:52', '2024-03-06 06:53:52', 0),
        (32, 50, 2000, 15000, 0, 0, 33, '2024-03-06 06:56:57', '2024-03-06 06:56:57', 0),
        (33, 50, 2000, 115000, 0, 0, 34, '2024-03-06 06:59:16', '2024-03-06 06:59:16', 0),
        (34, 50, 2000, 15000, 0, 0, 35, '2024-03-06 07:01:59', '2024-03-06 07:01:59', 0),
        (35, 50, 2000, 15000, 0, 0, 36, '2024-03-06 07:03:49', '2024-03-06 07:03:49', 0),
        (36, 50, 2000, 15000, 0, 0, 37, '2024-03-06 07:06:09', '2024-03-06 07:06:09', 0),
        (37, 50, 2000, 15000, 0, 0, 38, '2024-03-06 07:08:30', '2024-03-06 07:08:30', 0),
        (38, 50, 2000, 150000, 0, 0, 39, '2024-03-06 07:10:10', '2024-03-06 07:10:10', 0),
        (39, 50, 2000, 15000, 0, 0, 40, '2024-03-06 07:12:17', '2024-03-06 07:12:17', 0),
        (40, 50, 3000, 20000, 0, 0, 41, '2024-03-06 07:14:15', '2024-03-06 07:14:15', 0),
        (41, 50, 3000, 30000, 0, 0, 42, '2024-03-06 07:17:32', '2024-03-06 07:17:32', 0),
        (42, 50, 2000, 15000, 0, 0, 43, '2024-03-07 07:20:51', '2024-03-07 07:20:51', 0),
        (43, 50, 3000, 10000, 0, 0, 44, '2024-03-07 07:25:30', '2024-03-07 07:25:30', 0),
        (44, 50, 1000, 30000, 0, 0, 45, '2024-03-07 07:34:30', '2024-03-07 07:34:30', 0),
        (45, 50, 100, 13000, 0, 0, 46, '2024-03-07 08:25:11', '2024-03-07 08:25:11', 0),
        (46, 30, 1000, 10000, 0, 0, 47, '2024-03-07 08:27:03', '2024-03-07 08:27:03', 0),
        (47, 50, 2000, 30000, 0, 0, 48, '2024-03-07 08:29:14', '2024-03-07 08:29:14', 0),
        (48, 20, 1000, 10000, 0, 0, 49, '2024-03-07 08:32:39', '2024-03-07 08:32:39', 0),
        (49, 50, 1000, 10000, 0, 0, 50, '2024-03-07 08:36:36', '2024-03-07 08:36:36', 0),
        (50, 30, 1000, 10000, 0, 0, 51, '2024-03-07 08:40:02', '2024-03-07 08:40:02', 0),
        (51, 50, 2000, 10000, 0, 0, 52, '2024-03-07 08:42:11', '2024-03-07 08:42:11', 0),
        (52, 50, 3000, 30000, 0, 0, 53, '2024-03-07 08:46:03', '2024-03-07 08:46:03', 0),
        (53, 50, 4000, 30000, 0, 0, 54, '2024-03-07 08:49:50', '2024-03-07 08:49:50', 0),
        (54, 100, 5000, 30000, 0, 0, 55, '2024-03-07 08:54:34', '2024-03-07 08:54:34', 0),
        (55, 300, 10000, 100000, 0, 0, 56, '2024-03-07 08:59:55', '2024-03-07 08:59:55', 0);
