package utils

import (
	"encoding/hex"
	"strings"
)

func CombineBytes(b ...[]byte) []byte {
	var result []byte
	for _, v := range b {
		result = append(result, v...)
	}
	return result
}

func FromHex(hexstr string) []byte {
	if strings.HasPrefix(hexstr, "0x") {
		hexstr = hexstr[2:]
	}
	d, _ := hex.DecodeString(hexstr)
	return d
}
