package standardlib

import (
	"github.com/magiconair/properties/assert"
	"github.com/odysseus/nodemanager/config"
	log "github.com/sirupsen/logrus"
	"testing"
)

func TestNewStandardTasks(t *testing.T) {
	config.ParseConfig("../config.toml")
	s := NewStandardTasks()
	{
		ts, exist := s.GetTask(998)
		assert.Equal(t, exist, true)

		log.Print(ts.Standlib)
		lib := s.GetStdLib(ts.TaskType)
		if lib == nil {
			t.Fail()
		}
	}
	{
		_, exist := s.GetTask(10)
		assert.Equal(t, exist, false)
	}

}
