package metrics

import (
	"fmt"
	"github.com/odysseus/nodemanager/config"
	"github.com/prometheus/client_golang/prometheus"
	"github.com/prometheus/client_golang/prometheus/promhttp"
	log "github.com/sirupsen/logrus"
	"net/http"
	_ "net/http/pprof"
)

const (
	Namespace = "nodemanager"
)

func NewRegisteredCounterVec(subname string, name string, labels []string) *prometheus.CounterVec {
	counterVec := prometheus.NewCounterVec(
		prometheus.CounterOpts{
			Namespace: Namespace,
			Subsystem: subname,
			Name:      name,
		},
		labels,
	)
	prometheus.MustRegister(counterVec)
	return counterVec
}

func NewRegisteredGauge(subname string, name string, labels []string) *prometheus.GaugeVec {
	gaugeVec := prometheus.NewGaugeVec(
		prometheus.GaugeOpts{
			Namespace: Namespace,
			Subsystem: subname,
			Name:      name,
		},
		labels,
	)
	prometheus.MustRegister(gaugeVec)
	return gaugeVec
}

func NewRegisteredGaugeNoVec(subname string, name string) prometheus.Gauge {
	gaugeVec := prometheus.NewGauge(
		prometheus.GaugeOpts{
			Namespace: Namespace,
			Subsystem: subname,
			Name:      name,
		},
	)
	prometheus.MustRegister(gaugeVec)
	return gaugeVec
}

func NewRegisteredHistogram(subname string, name string, labels []string) *prometheus.HistogramVec {
	histogramVec := prometheus.NewHistogramVec(
		prometheus.HistogramOpts{
			Namespace: Namespace,
			Subsystem: subname,
			Name:      name,
		},
		labels,
	)
	prometheus.MustRegister(histogramVec)
	return histogramVec
}

func NewRegisteredSummary(subname string, name string, labels []string) *prometheus.SummaryVec {
	summaryVec := prometheus.NewSummaryVec(
		prometheus.SummaryOpts{
			Namespace: Namespace,
			Subsystem: subname,
			Name:      name,
		},
		labels,
	)
	prometheus.MustRegister(summaryVec)
	return summaryVec
}

func NewRegisteredMeter(subname string, name string) prometheus.Counter {
	counter := prometheus.NewCounter(
		prometheus.CounterOpts{
			Namespace: Namespace,
			Subsystem: subname,
			Name:      name,
		},
	)
	prometheus.MustRegister(counter)
	return counter
}

func StartMetrics() {
	addr := fmt.Sprintf(":%d", config.GetConfig().MetricPort)
	http.Handle("/metrics", promhttp.Handler())
	err := http.ListenAndServe(addr, nil)
	if err != nil {
		log.Errorf("metrics server exit: %s", err.Error())
	}
}
