package server

import (
	"encoding/json"
	"fmt"
	"github.com/odysseus/service-registry/common"
	"github.com/odysseus/service-registry/query"
	"github.com/odysseus/service-registry/registry"
)

var (
	wr registry.Register = workerRegistry{}
)

type workerRegistry struct {
	worker *Worker
	wm     *WorkerManager
}

func (w workerRegistry) ServiceType() common.ServiceType {
	return common.SERVICE_WORKER
}

func (w workerRegistry) Instance() string {
	return fmt.Sprintf("%s", w.worker.workerAddr)
}

func (w workerRegistry) Status() string {
	return fmt.Sprintf("%s", w.worker.status)
}

func (w workerRegistry) DetailInfo() (json.RawMessage, error) {
	if w.worker == nil {
		return nil, fmt.Errorf("worker is nil")
	}
	if w.worker.workerAddr == "" {
		return nil, fmt.Errorf("worker address is empty")
	}

	info := query.WorkerInfo{}
	if w.worker.info.nodeInfo != nil {
		info.BenefitAddress = w.worker.info.nodeInfo.BenefitAddress
		info.IP = w.worker.info.nodeInfo.DeviceIp
	}

	info.ActiveNM, _ = w.wm.WorkerNmList(w.worker)
	info.HearBeat = w.wm.GetHeartBeat(w.worker.uuid)
	info.MinerAddress = w.worker.workerAddr
	info.Nonce = int64(w.worker.nonce)
	return json.Marshal(info)
}
