package standardlib

import (
	"fmt"
	"math/rand"
)

type SmallCar struct {
}

func init() {
	RegisterStdLib("smallcar", &SmallCar{})
}

func (g *SmallCar) GenerateParam(difficult int) (string, error) {
	m := rand.Intn(256)
	param := fmt.Sprintf("{\n    \"model_name\": \"Realistic_Vision_V1.4\",\n    \"model_type\": \"tex2img\",\n    \"desc\": {\n        \"prompt\": \" a car with number %d\",\n        \"steps\": 20\n        }\n}", m)

	return param, nil
}

func (g *SmallCar) VerifyResult(param string, result []byte) bool {
	if len(result) > 0 {
		return true
	}
	return false
}
