package server

import (
	"context"
	"fmt"
	"github.com/odysseus/nodemanager/config"
	log "github.com/sirupsen/logrus"
	"strconv"
)

func (wm *WorkerManager) UpdateWorkerDeviceInfo(worker *Worker, deviceInfos string) {
	deviceInfoKey := config.WORKER_DEVICE_INFO_PREFIX + worker.addr
	wm.rdb.Set(context.Background(), deviceInfoKey, deviceInfos, 0)
}

func (wm *WorkerManager) AddWorkerFirst(worker *Worker) error {
	log.WithField("worker", worker.addr).Info("add worker first time.")
	for _, device := range worker.deviceInfo {
		// add device to redis
		priority := 0
		_ = device // todo: set priority with device info.
		if err := wm.rdb.RPush(context.Background(), config.WORKER_QUEUE_PREFIX+strconv.Itoa(priority), workerId(worker)).Err(); err != nil {
			continue
		}
	}
	// add worker to redis queue
	wm.ActiveWorker(worker)

	return nil
}

func (wm *WorkerManager) AddWorkerSingle(worker *Worker) error {
	log.WithField("worker", worker.addr).Info("add worker on back.")
	{
		// add worker to redis queue
		priority := 0
		if err := wm.rdb.RPush(context.Background(), config.WORKER_QUEUE_PREFIX+strconv.Itoa(priority), workerId(worker)).Err(); err != nil {
			log.WithError(err).Error("add worker back to queue failed.")
		}
	}
	// add worker to redis queue
	wm.ActiveWorker(worker)
	return nil
}

func (wm *WorkerManager) ActiveWorker(worker *Worker) {
	wm.rdb.SAdd(context.Background(), workerStatusKey(worker), config.GetConfig().PublicEndpoint())
}

func (wm *WorkerManager) InActiveWorker(worker *Worker) {
	wm.rdb.SRem(context.Background(), workerStatusKey(worker), config.GetConfig().PublicEndpoint())
}

func workerStatusKey(w *Worker) string {
	id := workerId(w)
	return fmt.Sprintf("%s_%s", config.WORKER_STATUS_PREFIX, id)
}

func workerId(w *Worker) string {
	return fmt.Sprintf("%s_%d", w.addr, w.uuid)
}
