package standardlib

import (
	"bytes"
	"fmt"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/crypto"
	"math/rand"
)

type GenEthAddr struct {
}

func init() {
	RegisterStdLib("ethaddr", &GenEthAddr{})
}

func (g *GenEthAddr) GenerateParam(difficult int) (string, error) {
	m := rand.Intn(256) // random prefix 2 length
	for i := 0; i < difficult; i++ {
		n := rand.Intn(256) // append prefix 2 length
		m = m<<8 | n
	}

	return fmt.Sprintf("%02x", m), nil
}

func (g *GenEthAddr) VerifyResult(param string, result []byte) bool {
	pk, err := crypto.ToECDSA(result)
	if err != nil {
		return false
	}

	addr := crypto.PubkeyToAddress(pk.PublicKey)
	pm := common.Hex2Bytes(param)
	if len(param) > len(addr.Bytes()) {
		return false
	}
	return bytes.Compare(addr.Bytes()[:len(pm)], pm) == 0
}
