package nm

import (
	"context"
	"example.com/m/conf"
	"example.com/m/log"
	"example.com/m/operate"
	nodeManagerV1 "github.com/odysseus/odysseus-protocol/gen/proto/go/nodemanager/v1"
	"google.golang.org/grpc"
	"time"
)

func monitorNodeManagerSeed() {
	connectNmCumulativeCount := 0
	ticker := time.NewTicker(time.Second * 1)
	for {
		select {
		case <-ticker.C:
			seed := conf.GetConfig().NmSeed
			log.Info("Nm seed url:", seed)
			seedServiceClient := operate.ConnNmGrpc(seed)
			if seedServiceClient == nil {
				if connectNmCumulativeCount == conf.GetConfig().AllowConnNmCount {
					log.Error("Dial nm seed service client failed")
					continue
				}
				log.Warn("Connect nm seed service client is nil")
				connectNmCumulativeCount++
				continue
			}
			list, err := seedServiceClient.ManagerList(context.Background(), &nodeManagerV1.ManagerListRequest{}, grpc.EmptyCallOption{})
			if err != nil {
				if connectNmCumulativeCount == conf.GetConfig().AllowConnNmCount {
					log.Error("Nm seed seed service is dealing")
					continue
				}
				log.WithError(err).Warn("Get manager list failed through nm seed service")
				connectNmCumulativeCount++
				continue
			}
			if list.GetManagers() == nil || len(list.GetManagers()) == 0 {
				log.Warn("Get managers is empty through Nm seed service")
				continue
			}
			for _, node := range list.GetManagers() {
				if isExistNodeManager(node) {
					log.Warn("Node manager is already exist and updated")
					continue
				}
				nodeManagerArr = append(nodeManagerArr, &NodeManager{Info: node, IsUsed: false, IsExist: true})
			}
			isInit = true
			ticker = time.NewTicker(time.Minute * 10)
		}
	}
}
