package win

import (
	"example.com/m/log"
	"github.com/kardianos/service"
	"os"
	"time"
)

type program struct{}

func Run() {
	srvConfig := &service.Config{
		Name:        "NodeService",
		DisplayName: "NodeServiceRun",
		Description: "The service is miner for node",
	}
	prg := &program{}
	s, err := service.New(prg, srvConfig)
	if err != nil {
		log.Error("New service failed: ", err)
		return
	}
	if len(os.Args) > 1 {
		serviceAction := os.Args[1]
		switch serviceAction {
		case "install":
			err := s.Install()
			if err != nil {
				log.Error("安装服务失败: ", err.Error())
			} else {
				log.Info("安装服务成功")
			}
			return
		case "uninstall":
			err := s.Uninstall()
			if err != nil {
				log.Error("卸载服务失败: ", err.Error())
			} else {
				log.Info("卸载服务成功")
			}
			return
		case "start":
			err := s.Start()
			if err != nil {
				log.Error("运行服务失败: ", err.Error())
			} else {
				log.Info("运行服务成功")
			}
			return
		case "stop":
			err := s.Stop()
			if err != nil {
				log.Error("停止服务失败: ", err.Error())
			} else {
				log.Info("停止服务成功")
			}
			return
		}
	}
}

func (p *program) Start(s service.Service) error {
	log.Info("service start...")
	go p.run()
	return nil
}

func (p *program) run() {
	for {
		time.Sleep(time.Second)
		log.Info("running")
	}
}

func (p *program) Stop(s service.Service) error {
	err := s.Stop()
	if err != nil {
		log.Error("service stop...", err.Error())
		return err
	}
	return nil
}
