package db

import (
	"example.com/m/log"
	"github.com/syndtr/goleveldb/leveldb"
	"github.com/syndtr/goleveldb/leveldb/iterator"
)

var dbInstance *leveldb.DB

var err error

func init() {
	// 打开或创建一个LevelDB数据库
	dbInstance, err = leveldb.OpenFile("data/mydb", nil)
	if err != nil {
		log.Error("Leveldb open file failed: ", err)
	}

	// 遍历数据库，删除所有数据
	iter := dbInstance.NewIterator(nil, nil)
	for iter.Next() {
		key := iter.Key()
		// 删除 key 对应的数据
		if err := dbInstance.Delete(key, nil); err != nil {
			log.Error("Leveldb delete failed: ", err)
		}
	}
	iter.Release()
	//defer func(dbInstance *leveldb.DB) {
	//	err := dbInstance.Close()
	//	if err != nil {
	//		log.Error("Leveldb close file failed: ", err)
	//	}
	//}(dbInstance)
}

func Put(key string, value []byte) error {
	// 存储数据
	err := dbInstance.Put([]byte(key), value, nil)
	if err != nil {
		log.Error("Leveldb put data failed:", err)
		return err
	}
	return nil
}

func NewIterator() (iterator.Iterator, error) {
	// 存储数据
	iteratorRes := dbInstance.NewIterator(nil, nil)
	if iteratorRes.Error() != nil {
		log.Error("Leveldb new iterator failed:", err)
		return nil, err
	}
	return iteratorRes, nil
}

func Get(key string) ([]byte, error) {
	data, err := dbInstance.Get([]byte(key), nil)
	if err != nil {
		log.Error("Leveldb get data failed:", err)
		return nil, err
	}
	log.WithField("key", key).WithField("value", data).Info("leveldb data")
	return data, nil
}

func Delete(key []byte) error {
	err := dbInstance.Delete(key, nil)
	if err != nil {
		log.Error("Leveldb del data failed:", err)
		return err
	}
	return nil
}
