package controllers

import (
	"encoding/json"
	"example.com/m/conf"
	"example.com/m/models"
	"example.com/m/nm"
	"example.com/m/operate"
	nodeManagerV1 "github.com/odysseus/odysseus-protocol/gen/proto/go/nodemanager/v1"
	"io"
)

type NodeController struct {
	BaseController
}

func (c *NodeController) SetNmSeed() {
	bodyReq, err := io.ReadAll(c.Ctx.Request.Body)
	if err != nil || bodyReq == nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	req := &models.SeedUrl{}
	err = json.Unmarshal(bodyReq, req)
	if err != nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	serviceClient := operate.ConnNmGrpc(req.Seed)
	if serviceClient == nil {
		c.ResponseInfo(500, "seed is not connected", "")
	}
	conf.GetConfig().SetNmSeed(req.Seed)
	c.ResponseInfo(200, "set seed successful", "")
}

func (c *NodeController) SetRewardAddress() {
	bodyReq, err := io.ReadAll(c.Ctx.Request.Body)
	if err != nil || bodyReq == nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	req := &models.RewardAddress{}
	err = json.Unmarshal(bodyReq, req)
	if err != nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	if !conf.GetConfig().SetRewardAddress(req.Address) {
		c.ResponseInfo(500, "param is not address", "")
	}
	c.ResponseInfo(200, "sign successful", "")
}

func (c *NodeController) AddNodeManager() {
	bodyReq, err := io.ReadAll(c.Ctx.Request.Body)
	if err != nil || bodyReq == nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	req := &models.NodeManagerReq{}
	err = json.Unmarshal(bodyReq, req)
	if err != nil || req.PublicKey == "" || req.EndPoint == "" {
		c.ResponseInfo(500, "param error", "")
		return
	}
	nodeManager := &nodeManagerV1.NodeManagerInfo{
		Publickey: req.PublicKey,
		Endpoint:  req.EndPoint,
	}
	nm.AddNodeManager(nodeManager)
	c.ResponseInfo(200, "sign successful", "")

}

func (c *NodeController) GetNodeManagers() {
	manager := nm.GetNodeManagers()
	res := make([]*nm.NodeManager, 0)
	for _, nodeManager := range manager {
		if !nodeManager.IsExist {
			continue
		}
		if nodeManager.IsUsed {
			res = append(res, nodeManager)
		}
	}
	c.ResponseInfo(200, "Get used node manager successful", res)
}
