package conf

import (
	"crypto/ecdsa"
	"github.com/ethereum/go-ethereum/common"
)

type Config struct {
	NmSeed              string `json:"nm_seed"`
	SignPrv             string
	SignPrivateKey      *ecdsa.PrivateKey
	SignPub             string
	SignPublicAddress   common.Address
	DockerServer        string `json:"docker_server"`
	HeartRespTimeSecond int64  `json:"heart_response"`
	HeartRespTimeMillis int64
	TaskValidatorTime   float64 `json:"task_validator_time"`
	BenefitAddress      string
	ContainerNum        int64  `json:"container_num"`
	NodeManagerNum      int64  `json:"node_manager_num"`
	ChainID             int64  `json:"chain_id"`
	ApiUrl              string `json:"api_url"`
	ValidatorUrl        string `json:"validator_url"`
}

var _cfg *Config = nil

func init() {
	_cfg = &Config{}
}

func GetConfig() *Config {
	return _cfg
}

func (c *Config) SetRewardAddress(addr string) bool {
	isAddr := common.IsHexAddress(addr)
	if isAddr {
		c.BenefitAddress = addr
	}
	return isAddr
}

func (c *Config) SetNmSeed(seed string) {
	c.NmSeed = seed
}
