package nm

import (
	"example.com/m/conf"
	"example.com/m/largeModel"
	"example.com/m/log"
	"example.com/m/models"
	"example.com/m/operate"
	"example.com/m/utils"
	"time"
)

// 指定远程 Docker 服务的地址
var (
	nodeManagerArr        []*NodeManager
	usedNodeManagerClient []*models.NodeManagerClient
)

func init() {
	nodeManagerArr = make([]*NodeManager, 0)
	usedNodeManagerClient = make([]*models.NodeManagerClient, 0)
}

func StartMonitor() {
	IsRecvTask = true
	dockerOp := operate.NewDockerOp()
	if !dockerOp.IsHealthy {
		log.Error("Docker operation is not healthy reason:", dockerOp.Reason)
		panic("Docker client is not healthy")
	}

	modelHandler := largeModel.NewModelHandler(dockerOp)

	monitorNm := NewMonitorNm(dockerOp, modelHandler)

	go modelHandler.MonitorModelInfo()
	log.WithField("func", "MonitorModelInfo").Info("--------------------Start modelHandler--------------------")

	go modelHandler.MonitorModelStatus()
	log.WithField("func", "MonitorModelStatus").Info("--------------------Start modelHandler--------------------")

	go monitorNm.monitorNodeManagerSeed()
	log.WithField("func", "monitorNodeManagerSeed").Info("--------------------Start monitorNm--------------------")

	for {
		if monitorNm.IsInit && modelHandler.IsInit {
			break
		}
		time.Sleep(time.Second * 3)
	}

	go monitorNm.monitorNmClient()
	log.WithField("func", "monitorNmClient").Info("--------------------Start monitorNm--------------------")

	var connectNodeManagerCount int64 = 0
	selectClientRandomNum := utils.GenerateRandomNumber(conf.GetConfig().SignPrivateKey, conf.GetConfig().NodeManagerNum)
	isSelect := false
	for i := 0; i < len(nodeManagerArr); i++ {
		// TODO: 需要对索引进行一定的规则判断，随机选择其中的nodeManager进行链接
		if connectNodeManagerCount == conf.GetConfig().NodeManagerNum {
			log.Warn("Nothing available node manager..................................")
			break
		}
		randomNum := utils.GenerateRandomNumber(conf.GetConfig().SignPrivateKey, int64(len(nodeManagerArr)))
		manager := nodeManagerArr[randomNum.Int64()]
		if !manager.IsExist {
			log.WithField("endpoint", manager.Info.Endpoint).Warn("node manager is not exist")
			continue
		}
		if !manager.IsUsed {
			if selectClientRandomNum.Int64() == connectNodeManagerCount {
				isSelect = true
			} else {
				isSelect = false
			}
			isSuccess := inputNodeManagerChan(manager, nil, isSelect, monitorNm)
			if !isSuccess {
				log.Warn("Init input node manager chan failed")
				continue
			}
			connectNodeManagerCount++
		}
	}

	ticker := time.NewTicker(time.Second * 5)
	defer ticker.Stop()
	for {
		select {
		case <-ticker.C:
			log.Info("Monitoring node manager client thread start......")
			for _, client := range usedNodeManagerClient {
				if !IsRecvTask && !client.Status {
					client.Status = false
				}
				log.WithField("Endpoint", client.Endpoint).WithField("LastHeartTime", client.LastHeartTime).WithField("Is Del", client.IsDel).WithField("Status", client.Status).Info("Monitoring node manager client thread")
			}
			if !IsRecvTask {
				log.Warn("Stop receive task.........")
				continue
			}
			for i, managerClient := range usedNodeManagerClient {
				if managerClient.GetStatus() && !managerClient.IsDel {
					sub := time.Now().Sub(managerClient.GetLastHeartTime()).Seconds()
					log.WithField("time(uint seconds)", sub).Info("Main thread monitor nm heartbeat time")
					if int64(sub) > conf.GetConfig().HeartRespTimeSecond {
						managerClient.UpdateStatus(false)
					}
				}
				if !managerClient.GetStatus() && !managerClient.IsDel {
					log.Warn("The Node manager client is failed:", managerClient.Endpoint)
					manager := getNodeManager(managerClient.Endpoint)
					if manager == nil {
						log.Warn("The managerClient is not exist:", managerClient.Endpoint)
						continue
					}
					managerClient.IsDel = true
					usedNodeManagerClient = utils.DeleteNm(usedNodeManagerClient, i)
					log.WithField("Endpoint", managerClient.Endpoint).Warn("Node manager client is deleted")
					//  重试连接三次
					tryConnectIsSuccess := false
					for j := 1; j <= 3; j++ {
						tryConnectIsSuccess = inputNodeManagerChan(manager, nil, managerClient.IsSelected, monitorNm)
						log.WithField("is success", tryConnectIsSuccess).Warn("Try to connect node manager client:", manager.Info.Endpoint)
						if tryConnectIsSuccess {
							log.Info("Connect node manager client success:", manager.Info.Endpoint)
							break
						}
						log.WithField("count", i).WithField("endpoint", manager.Info.Endpoint).Warn("Retrying node manager client connect")
					}
					if tryConnectIsSuccess {
						continue
					}

					// 从未使用的nm列表中选取新的nm进行连接
					unUsedNodeManagers := getUnUsedNodeManagers()
					if unUsedNodeManagers == nil || len(unUsedNodeManagers) == 0 {
						log.Warn("There is no node manager available at this time")
						break
					}
					// 从已存在的节点中选择一个提交DeviceInfo
					isSelect := false
					if managerClient.IsSelected {
						for _, client := range usedNodeManagerClient {
							if client.Status && !client.IsDel {
								isSelect = true
								client.IsSelected = true
								break
							}
						}
					}

					for i := 0; i < len(unUsedNodeManagers); i++ {
						if !isSelect {
							isSelect = true
						}
						randomNum := utils.GenerateRandomNumber(conf.GetConfig().SignPrivateKey, int64(len(nodeManagerArr)))
						unUsedManager := unUsedNodeManagers[randomNum.Int64()]
						isSuccess := inputNodeManagerChan(unUsedManager, nil, isSelect, monitorNm)
						if isSuccess {
							log.Info("Connect unused node manager client successful:", manager.Info.Endpoint)
							break
						} else {
							log.Warn("Connect unused node manager client error:", manager.Info.Endpoint)
						}
					}
				}
			}
		}
	}
}

func inputNodeManagerChan(manager *NodeManager, nodeManagerClient *models.NodeManagerClient, isSelect bool, monitorNm *MonitorNm) bool {
	if nodeManagerClient == nil {
		nodeManagerClient = &models.NodeManagerClient{
			PublicKey:     manager.Info.Publickey,
			Endpoint:      manager.Info.Endpoint,
			Location:      manager.Info.Location,
			Status:        true,
			IsSelected:    isSelect,
			LastHeartTime: time.Now(),
		}
		usedNodeManagerClient = append(usedNodeManagerClient, nodeManagerClient)
	}
	serviceClient := operate.ConnNmGrpc(manager.Info.Endpoint)
	if serviceClient == nil {
		log.WithField("endPoint", manager.Info.Endpoint).Error("Connect node manager failed")
		return false
	}
	nodeManagerClient.Status = true
	nodeManagerClient.Client = serviceClient
	monitorNm.NodeManagerClientChan <- nodeManagerClient
	manager.IsUsed = true
	if isSelect {
		RunningState.NmIpAddr = nodeManagerClient.Endpoint
		RunningState.NmLocation = nodeManagerClient.Location
	}
	return true
}
