package models

type BarkOutPut struct {
	AudioOut string `json:"audio_out"`
}

type SwinirOutPut struct {
	File string `json:"file"`
}

type WhisperOutPut struct {
	Segments []struct {
		Id               string  `json:"id"`
		End              float64 `json:"end"`
		Seek             int     `json:"seek"`
		Text             string  `json:"text"`
		Start            int     `json:"start"`
		Tokens           []int   `json:"tokens"`
		AvgLogprob       float64 `json:"avg_log_prob"`
		Temperature      int     `json:"temperature"`
		NoSpeechProb     float64 `json:"no_speech_prob"`
		CompressionRatio float64 `json:"compression_ratio"`
	} `json:"segments"`
}

type WhisperDiarizationOutPut struct {
	Language string `json:"language"`
	Segments []struct {
		End   string `json:"end"`
		Text  string `json:"text"`
		Start string `json:"start"`
		Words []struct {
			End         float64 `json:"end"`
			Word        string  `json:"word"`
			Start       float64 `json:"start"`
			Probability float64 `json:"probability"`
		} `json:"words"`
		Speaker    string  `json:"speaker"`
		AvgLogprob float64 `json:"avg_logprob"`
	} `json:"segments"`
	NumSpeakers int `json:"num_speakers"`
}

type IncrediblyFastWhisper struct {
	Text   string `json:"text"`
	Chunks []struct {
		Text      string    `json:"text"`
		Timestamp []float64 `json:"timestamp"`
	} `json:"chunks"`
}

type ClipFeatures struct {
	Input     string    `json:"input"`
	Embedding []float64 `json:"embedding"`
}

type AllMpnetBaseV2 struct {
	Embedding []float64 `json:"embedding"`
}
