package main

import (
	"example.com/m/conf"
	"example.com/m/log"
	"github.com/ethereum/go-ethereum/common"
	"github.com/spf13/cobra"
)

var (
	rewardAddr  string
	isSetReward bool
)

func init() {
	RootCmd.AddCommand(paramCmd)
	rewardAddr = *paramCmd.Flags().StringP("reward", "r", "", "Print detail version info")
}

// versionCmd represents the base command when called without any subcommands
var paramCmd = &cobra.Command{
	Use:   "param",
	Short: "Print version number",
	Long:  ``,
	Run: func(cmd *cobra.Command, args []string) {
		if rewardAddr != "" && common.IsHexAddress(rewardAddr) {
			isSetReward = conf.GetConfig().SetRewardAddress(rewardAddr)
			if !isSetReward {
				log.Error("Please set right reward address")
			}
		}
	},
}
