package main

import (
	"example.com/m/log"
	"example.com/m/nm"
	"github.com/astaxie/beego"
	"github.com/spf13/cobra"
	"os"
)

var (
	routineCount uint
)

// RootCmd represents the base command when called without any subcommands
var RootCmd = &cobra.Command{
	Use:   "miner",
	Short: "The miner command-line interface",
	Long:  ``,
	Run: func(cmd *cobra.Command, args []string) {
		if isSetReward {
			log.InitLog(log.LogConfig{Path: "logs", Level: "debug", Save: 3})
			go nm.StartMonitor()
			beego.Run()
		}
	},
}

func init() {
	//cobra.OnInitialize(initConfig)
	RootCmd.PersistentFlags().UintVar(&routineCount, "routine", 2, "routine count for corrupt do task")
}

func Execute() {
	if err := RootCmd.Execute(); err != nil {
		log.Error("root cmd execute failed", err)
		os.Exit(-1)
	}
}
