package operate

import (
	"example.com/m/log"
	"fmt"
	"github.com/go-cmd/cmd"
	"os/exec"
)

type Command struct {
	cmd        string
	params     []byte
	scriptPath string
}

func GetSystemCommand(cmd string, params []byte) *Command {
	return &Command{}
}

func (c *Command) ExecCommand(name string, param []string) {
	// 创建一个新的 cmd.Cmd 结构体，表示要执行的 curl 命令
	command := cmd.NewCmd(name, param...)

	// 阻塞并等待命令执行完成
	status := <-command.Start()

	// 检查命令执行的状态
	if status.Error != nil {
		fmt.Println("Error executing command:", status.Error)
		return
	}

	// 打印命令的标准输出
	if len(status.Stdout) > 0 {
		log.Info("Command output:", status.Stdout)
	}

	// 打印命令的标准错误
	if len(status.Stderr) > 0 {
		log.Error("Command error:", status.Stderr)
	}
}

func (c *Command) ExecShell() {
	// 使用 exec.Command 执行脚本文件
	shellCmd := exec.Command("sh", c.scriptPath)

	// 执行命令并捕获输出
	output, err := shellCmd.CombinedOutput()
	if err != nil {
		log.Error("Error executing script:", err)
		return
	}

	// 打印输出结果
	log.Info("Script output:", string(output))
}
