package nm

import (
	"example.com/m/conf"
	"example.com/m/largeModel"
	"example.com/m/log"
	"example.com/m/models"
	"example.com/m/operate"
	"example.com/m/utils"
	"time"
)

// 指定远程 Docker 服务的地址
var (
	nodeManagerArr        []*NodeManager
	usedNodeManagerClient []*models.NodeManagerClient
)

func init() {
	nodeManagerArr = make([]*NodeManager, 0)
	usedNodeManagerClient = make([]*models.NodeManagerClient, 0)
}

func StartMonitor() {
	dockerOp := operate.NewDockerOp()
	if !dockerOp.IsHealthy {
		log.Error("Docker operation is not healthy reason:", dockerOp.Reason)
		panic("Docker client is not healthy")
	}

	modelHandler := largeModel.NewModelHandler(dockerOp)

	monitorNm := NewMonitorNm(dockerOp)

	go monitorNm.monitorNodeManagerSeed()

	go monitorNm.monitorNmClient()

	go modelHandler.MonitorModelInfo()

	for !monitorNm.IsInit {
	}

	var connectNodeManagerCount int64 = 0
	selectClientRandomNum := utils.GenerateRandomNumber(conf.GetConfig().SignPrivateKey, conf.GetConfig().NodeManagerNum)
	isSelect := false
	for i := 0; i < len(nodeManagerArr); i++ {
		// TODO: 需要对索引进行一定的规则判断，随机选择其中的nodeManager进行链接
		if connectNodeManagerCount == conf.GetConfig().NodeManagerNum {
			log.Warn("Nothing available node manager..................................")
			break
		}
		randomNum := utils.GenerateRandomNumber(conf.GetConfig().SignPrivateKey, int64(len(nodeManagerArr)))
		manager := nodeManagerArr[randomNum.Int64()]
		if !manager.IsExist {
			log.WithField("endpoint", manager.Info.Endpoint).Warn("node manager is not exist")
			continue
		}
		if !manager.IsUsed {
			if selectClientRandomNum.Int64() == connectNodeManagerCount {
				isSelect = true
			} else {
				isSelect = false
			}
			isSuccess := inputNodeManagerChan(manager, nil, isSelect, monitorNm)
			if !isSuccess {
				log.Warn("Init input node manager chan failed")
				continue
			}
			connectNodeManagerCount++
		}
	}

	ticker := time.NewTicker(time.Second * 5)
	for {
		select {
		case <-ticker.C:
			log.Info("Monitoring node manager client thread start......")
			for _, client := range usedNodeManagerClient {
				log.WithField("Endpoint", client.Endpoint).WithField("LastHeartTime", client.LastHeartTime).WithField("Is Del", client.IsDel).WithField("Status", client.Status).Info("Monitoring node manager client thread")
			}
			for _, managerClient := range usedNodeManagerClient {
				if managerClient.GetStatus() && !managerClient.IsDel {
					sub := time.Now().Sub(managerClient.GetLastHeartTime()).Seconds()
					log.WithField("time(uint seconds)", sub).Info("Main thread monitor nm heartbeat time")
					if int64(sub) > conf.GetConfig().HeartRespTimeSecond {
						managerClient.UpdateStatus(false)
					}
				}
				if !managerClient.GetStatus() && !managerClient.IsDel {
					log.Warn("The Node manager client is failed:", managerClient.Endpoint)
					manager := getNodeManager(managerClient.Endpoint)
					if manager == nil {
						log.Warn("The managerClient is not exist:", managerClient.Endpoint)
						continue
					}
					if !managerClient.IsDel {
						// TODO: 重试连接三次
						managerClient.UpdateLastHeartTime(time.Now())
						isSuccess := inputNodeManagerChan(manager, managerClient, managerClient.IsSelected, monitorNm)
						log.WithField("is success", isSuccess).Warn("Try to connect node manager client:", manager.Info.Endpoint)
						if isSuccess {
							log.Info("Connect node manager client success:", manager.Info.Endpoint)
							continue
						}
					}
					managerClient.IsDel = true
					log.WithField("Endpoint", managerClient.Endpoint).Warn("Node manager client is deleted")
					unUsedNodeManagers := getUnUsedNodeManagers()
					if unUsedNodeManagers == nil || len(unUsedNodeManagers) == 0 {
						log.Warn("There is no node manager available at this time")
						break
					}
					if managerClient.IsSelected {
						for _, client := range usedNodeManagerClient {
							if client.Status && !client.IsDel {
								client.IsSelected = true
								break
							}
						}
					}
					for i := 0; i < len(unUsedNodeManagers); i++ {
						randomNum := utils.GenerateRandomNumber(conf.GetConfig().SignPrivateKey, int64(len(nodeManagerArr)))
						unUsedManager := unUsedNodeManagers[randomNum.Int64()]
						isSuccess := inputNodeManagerChan(unUsedManager, nil, false, monitorNm)
						if !isSuccess {
							log.Warn("Connect unused node manager client error:", manager.Info.Endpoint)
							break
						}
					}
				}
			}
		}
	}
}
