package controllers

import (
	"encoding/json"
	"example.com/m/conf"
	"example.com/m/models"
	"example.com/m/nm"
	"example.com/m/operate"
	"example.com/m/utils"
	nodemanagerV2 "github.com/odysseus/odysseus-protocol/gen/proto/go/nodemanager/v2"
	"io"
	"time"
)

type NodeController struct {
	BaseController
}

func (c *NodeController) SetNmSeed() {
	bodyReq, err := io.ReadAll(c.Ctx.Request.Body)
	if err != nil || bodyReq == nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	req := &models.SeedUrl{}
	err = json.Unmarshal(bodyReq, req)
	if err != nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	serviceClient := operate.ConnNmGrpc(req.Seed)
	if serviceClient == nil {
		c.ResponseInfo(500, "seed is not connected", "")
	}
	conf.GetConfig().SetNmSeed(req.Seed)
	c.ResponseInfo(200, "set seed successful", "")
}

func (c *NodeController) SetBenefitAddress() {
	bodyReq, err := io.ReadAll(c.Ctx.Request.Body)
	if err != nil || bodyReq == nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	req := &models.BenefitAddress{}
	err = json.Unmarshal(bodyReq, req)
	if err != nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	if !conf.GetConfig().SetBenefitAddress(req.Address) {
		c.ResponseInfo(500, "param is not address", "")
		return
	}
	isExist := false
	for _, s := range nm.HistoryBenefitAcc {
		if s == req.Address {
			isExist = true
		}
	}
	if !isExist {
		nm.HistoryBenefitAcc = append(nm.HistoryBenefitAcc, req.Address)
		err = utils.WriteBenefitFile(nm.HistoryBenefitAcc)
		if err != nil {
			c.ResponseInfo(500, "Write benefit file failed", "")
		}
	}
	c.ResponseInfo(200, "set benefit address successful", "")
}

func (c *NodeController) ListHistoryBenefitAddress() {
	fileBenefitAcc, _ := utils.ReadBenefitFile()
	c.ResponseInfo(200, "list history benefit address successful", fileBenefitAcc)
}

func (c *NodeController) AddNodeManager() {
	bodyReq, err := io.ReadAll(c.Ctx.Request.Body)
	if err != nil || bodyReq == nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	req := &models.NodeManagerReq{}
	err = json.Unmarshal(bodyReq, req)
	if err != nil || req.PublicKey == "" || req.EndPoint == "" {
		c.ResponseInfo(500, "param error", "")
		return
	}
	nodeManager := &nodemanagerV2.NodeManagerInfo{
		Publickey: req.PublicKey,
		Endpoint:  req.EndPoint,
	}
	nm.AddNodeManager(nodeManager)
	c.ResponseInfo(200, "add node manager successful", "")

}

func (c *NodeController) GetNodeManagers() {
	manager := nm.GetNodeManagers()
	res := make([]*nm.NodeManager, 0)
	for _, nodeManager := range manager {
		if !nodeManager.IsExist {
			continue
		}
		if nodeManager.IsUsed {
			res = append(res, nodeManager)
		}
	}
	c.ResponseInfo(200, "Get used node manager successful", res)
}

func (c *NodeController) UpdateRecvStatus() {
	bodyReq, err := io.ReadAll(c.Ctx.Request.Body)
	if err != nil || bodyReq == nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	req := &models.RecvTask{}
	err = json.Unmarshal(bodyReq, req)
	if err != nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	if !nm.IsRecvTask && req.IsRecv {
		nm.RunningState.RunningTime = time.Now().Unix()
		nm.RunningState.CompletedTaskCount = 0
	}
	nm.IsRecvTask = req.IsRecv
	c.ResponseInfo(200, "update recv status successful", "")
}

func (c *NodeController) GetRecvStatus() {
	c.ResponseInfo(200, "get recv status  successful", nm.IsRecvTask)
}

func (c *NodeController) GetConfigInfo() {
	c.ResponseInfo(200, "get config successful", conf.GetConfig())
}

func (c *NodeController) GetBenefit() {
	c.ResponseInfo(200, "get benefit address successful", conf.GetConfig().BenefitAddress)
}
