package controllers

import (
	"encoding/json"
	"example.com/m/conf"
	"example.com/m/models"
	"example.com/m/nm"
	"example.com/m/utils"
	"io"
)

type StateController struct {
	BaseController
}

func (c *StateController) GetRunningState() {
	res := nm.RunningState
	c.ResponseInfo(200, "get running state  successful", res)
}

func (c *StateController) GetRunningTp() {
	info := utils.GetHardwareInfo()
	if len(info.Data.Gpus) > 0 {
		var totalTemp int64
		for _, gpu := range info.Data.Gpus {
			totalTemp += gpu.Temp
		}
		avgTemp := totalTemp / int64(len(info.Data.Gpus))
		c.ResponseInfo(200, "get running state  successful", avgTemp)
	}
	c.ResponseInfo(500, "get running tp failed", 0)
}

func (c *StateController) GetWorkerInfo() {
	res := models.WorkerAccount{
		WorkerAcc: conf.GetConfig().SignPublicAddress.Hex(),
		ChainID:   conf.GetConfig().ChainID,
	}
	c.ResponseInfo(200, "get  worker info successful", res)
}

func (c *StateController) GetListGpuInfo() {
	info := utils.GetHardwareInfo()
	if info != nil && info.Data != nil {
		c.ResponseInfo(200, "get list gpu info successful", info.Data.Gpus)
		return
	}
	c.ResponseInfo(500, "get list gpu info failed", nil)
}

func (c *StateController) GetGpuUsageInfo() {
	bodyReq, err := io.ReadAll(c.Ctx.Request.Body)
	if err != nil || bodyReq == nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	req := &models.GpuUsageReq{}
	err = json.Unmarshal(bodyReq, req)
	if err != nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	info := utils.GetHardwareInfo()
	if info != nil {
		for _, gpu := range info.Data.Gpus {
			if gpu.Seq == req.Seq {
				c.ResponseInfo(200, "set seed successful", gpu)
				return
			}
		}
	}
	c.ResponseInfo(500, "get gpu usage info failed", nil)
}

func (c *StateController) GetOtherHardwareInfo() {
	info := utils.GetHardwareInfo()
	var diskTotal, diskFree int64
	for _, disk := range info.Data.Disk {
		for _, point := range disk.MountPoints {
			if point == "/" {
				diskTotal += disk.SizeBytes
				diskFree += disk.FreeBytes
				break
			}
		}
	}

	diskUsage := int32((1 - float64(diskFree)/float64(diskTotal)) * 100)
	res := &models.OtherHardwareInfoResp{
		NodeID:       conf.GetConfig().SignPublicAddress.Hex(),
		CpuName:      info.Data.Cpus.Model,
		CpuUsage:     info.Data.Cpus.Usage,
		CpuFrequency: info.Data.Cpus.Frequency,
		RamSize:      info.Data.Mem.Total,
		RamUsage:     info.Data.Mem.MemUtil,
		DiskSize:     diskTotal,
		DiskUsage:    diskUsage,
	}
	c.ResponseInfo(200, "get hardware info successful", res)
}
