package routers

import (
	"example.com/m/controllers"
	"github.com/astaxie/beego"
)

func init() {
	beego.Router("/api/v1/power/list/nm", &controllers.NodeController{}, "get:GetNodeManagers")
	beego.Router("/api/v1/power/set/nm/seed", &controllers.NodeController{}, "post:SetNmSeed")
	beego.Router("/api/v1/power/join/benefit/acc", &controllers.NodeController{}, "post:SetBenefitAddress")
	beego.Router("/api/v1/power/list/benefit/acc", &controllers.NodeController{}, "get:ListHistoryBenefitAddress")
	beego.Router("/api/v1/power/update/recv/status", &controllers.NodeController{}, "post:UpdateRecvStatus")
	beego.Router("/api/v1/power/get/recv/status", &controllers.NodeController{}, "get:GetRecvStatus")
	beego.Router("/api/v1/power/get/conf", &controllers.NodeController{}, "get:GetConfigInfo")
	beego.Router("/api/v1/power/get/current/benefit", &controllers.NodeController{}, "get:GetBenefit")
	beego.Router("/api/v1/power/get/running/tp", &controllers.StateController{}, "get:GetRunningTp")
	beego.Router("/api/v1/power/get/running/state", &controllers.StateController{}, "get:GetRunningState")
	beego.Router("/api/v1/power/get/worker/info", &controllers.StateController{}, "get:GetWorkerInfo")
	beego.Router("/api/v1/power/list/gpu/info", &controllers.StateController{}, "get:GetListGpuInfo")
	beego.Router("/api/v1/power/get/gpu/info", &controllers.StateController{}, "post:GetGpuUsageInfo")
	beego.Router("/api/v1/power/get/hardware/info", &controllers.StateController{}, "get:GetOtherHardwareInfo")
}
