package models

import (
	nodemanagerV2 "github.com/odysseus/odysseus-protocol/gen/proto/go/nodemanager/v2"
	"sync"
	"time"
)

type TaskCmd struct {
	ImageName string     `json:"image_name"`
	DockerCmd *DockerCmd `json:"docker_cmd"`
	ApiUrl    string     `json:"api_url"`
}

type DockerCmd struct {
	ContainerPort int64 `json:"container_port"`
	EnvMap        map[string]string
	HostIp        string
	HostPort      string
}

type TaskReq struct {
	TaskId     string `json:"task_id"`
	TaskParam  []byte `json:"task_param"`
	TaskResult []byte `json:"task_result"`
}

type TaskParam struct {
	Headers map[string][]string `json:"headers"`
	Queries map[string]string   `json:"queries"`
	Body    []byte              `json:"body"`
}

type ContainerRequest struct {
	WebHook string `json:"webhook"`
}

type TaskResult struct {
	TaskHttpHeaders    []byte
	TaskExecTime       int64
	TaskHttpStatusCode int32
	TaskRespBody       []byte
	TaskIsSuccess      bool
	TaskExecError      string
}

type ApiResp struct {
	TaskId     string   `json:"task_id"`
	TaskResult []string `json:"task_result"`
	TaskUid    string   `json:"task_uid"`
	TaskFee    string   `json:"task_fee"`
	IsSuccess  bool     `json:"is_success"`
	TaskError  string   `json:"task_error"`
}

type HardwareRequire struct {
	DiskSize   string     `json:"disk_size"`
	Gpus       []*GpuInfo `json:"gpus"`
	MemorySize string     `json:"memory_size"`
}

type GpuInfo struct {
	Gpu string `json:"gpu"`
}

type Gpu struct {
	Seq         int64  `json:"seq"`
	Uuid        string `json:"uuid"`
	Model       string `json:"model"`
	Performance int64  `json:"performance"`
	PowerRating int64  `json:"power_rating"`
	MemTotal    int64  `json:"mem_total"`
	MemFree     int64  `json:"mem_free"`
	Usage       int64  `json:"usage"`
	Temp        int64  `json:"temp"`
	PowerRt     int64  `json:"power_rt"`
}

type Cpu struct {
	Model     string `json:"model"`
	Number    int32  `json:"number"`
	Cores     int32  `json:"cores"`
	Threads   int32  `json:"threads"`
	Usage     int32  `json:"usage"`
	Frequency string `json:"frequency"`
}

type CoreCpuInfo struct {
	Seq    int64  `json:"seq"`
	Model  string `json:"model"`
	Thread int64  `json:"thread"`
	Core   int64  `json:"core"`
}

type Mem struct {
	Total   int64 `json:"total"`
	Free    int64 `json:"free"`
	MemUtil int32 `json:"mem_util"`
}

type Disk struct {
	Device      string   `json:"device"`
	MountPoints []string `json:"mount_points"`
	FreeBytes   int64    `json:"free_bytes"`
	SizeBytes   int64    `json:"size_bytes"`
}

type Net struct {
	Device   string `json:"device"`
	Speed    int32  `json:"speed"`
	SendRate int32  `json:"send_rate"`
	RecvRate int32  `json:"recv_rate"`
	Mac      string `json:"mac"`
}

type HardwareInfo struct {
	Gpus     []*Gpu  `json:"GPU"`
	Cpus     *Cpu    `json:"CPU"`
	Mem      Mem     `json:"RAM"`
	Disk     []*Disk `json:"DISK"`
	Networks []*Net  `json:"NET"`
}

type HardwareInfoRep struct {
	Code int           `json:"code"`
	Msg  string        `json:"msg"`
	Data *HardwareInfo `json:"hardware"`
}

type ModelInfo struct {
	Time            time.Time        `json:"time"`
	Count           int64            `json:"count"`
	HardwareRequire *HardwareRequire `json:"hardware_require"`
	Kind            int64            `json:"kind"`
	TaskId          uint64           `json:"task_id"`
	User            string           `json:"user"`
	Pwd             string           `json:"pwd"`
	SignUrl         string           `json:"sign_url"`
	ImageName       string           `json:"image_name"`
	FileExpiresTime string           `json:"file_expires_time"`
	PublishStatus   int              `json:"publish_status"`
	EstimatExeTime  int32            `json:"estimat_exe_time"`
	StartUpTime     int64            `json:"start_up_time"`
	RunningMem      int64            `json:"running_mem"`
	OpTime          int64
	SetupTime       int64
	LastRunTime     int64
	ImageId         string
	ContainerId     string
	IsInstalled     bool
	IsRunning       bool
	GpuSeq          int32
	GpuRam          int64
	LastWorkTime    int64
	TotalRunCount   int32
}

func (m *ModelInfo) UpdateFiled(model *ModelInfo) {
	m.Time = model.Time
	m.Count = model.Count
	m.HardwareRequire = model.HardwareRequire
	m.Kind = model.Kind
	m.TaskId = model.TaskId
	m.User = model.User
	m.Pwd = model.Pwd
	m.SignUrl = model.SignUrl
	m.FileExpiresTime = model.FileExpiresTime
	m.PublishStatus = model.PublishStatus
}

type HealthyCheck struct {
	Status string `json:"status"`
}

type FileCacheResult struct {
	Code int    `json:"code"`
	Msg  string `json:"msg"`
	Data string `json:"data"`
}

type ComputeResult struct {
	Code string `json:"code"`
	Msg  string `json:"msg"`
	Data string `json:"data"`
}

type BenefitAddressInfo struct {
	Address   string `json:"address"`
	Timestamp int64  `json:"timestamp"`
}

type NodeManagerClient struct {
	mutex         sync.Mutex
	LastHeartTime time.Time
	PublicKey     string
	Endpoint      string
	Client        nodemanagerV2.NodeManagerServiceClient
	Status        bool
	IsDel         bool
	IsSelected    bool
}

func (n *NodeManagerClient) GetLastHeartTime() time.Time {
	n.mutex.Lock()
	defer n.mutex.Unlock()
	return n.LastHeartTime
}

func (n *NodeManagerClient) UpdateLastHeartTime(time time.Time) {
	n.mutex.Lock()
	n.LastHeartTime = time
	n.mutex.Unlock()
}

func (n *NodeManagerClient) GetStatus() bool {
	n.mutex.Lock()
	defer n.mutex.Unlock()
	return n.Status
}

func (n *NodeManagerClient) UpdateStatus(status bool) {
	n.mutex.Lock()
	defer n.mutex.Unlock()
	n.Status = status
}
