package models

type BenefitAddress struct {
	Address string `json:"address"`
}

type RecvTask struct {
	IsRecv bool `json:"is_recv"`
}

type SeedUrl struct {
	Seed string `json:"seed"`
}

type NodeManagerReq struct {
	PublicKey string `json:"public_key"`
	EndPoint  string `json:"end_point"`
}

type RunningState struct {
	RunningTime        int64  `json:"running_time"`
	CompletedTaskCount int    `json:"completed_task_count"`
	NmIpAddr           string `json:"nm_ip_addr"`
	NmLocation         string `json:"nm_location"`
	NmDelayTime        int64  `json:"nm_delay_time"`
}

type WorkerAccount struct {
	WorkerAcc string `json:"worker_acc"`
	ChainID   int64  `json:"chain_id"`
}

type GpuUsageReq struct {
	Seq int64 `json:"seq"`
}

type OtherHardwareInfoResp struct {
	NodeID       string `json:"node_id"`
	CpuName      string `json:"cpu_name"`
	CpuUsage     int32  `json:"cpu_usage"`
	CpuFrequency string `json:"cpu_frequency"`
	RamSize      int64  `json:"ram_size"`
	RamUsage     int32  `json:"ram_usage"`
	DiskSize     int64  `json:"disk_size"`
	DiskUsage    int32  `json:"disk_usage"`
}

type Resp struct {
	Code int          `json:"code"`
	Msg  string       `json:"msg"`
	Data []*ModelInfo `json:"data"`
}
