package nm

import (
	"example.com/m/log"
	"example.com/m/models"
	"example.com/m/operate"
	nodeManagerV1 "github.com/odysseus/odysseus-protocol/gen/proto/go/nodemanager/v1"
	"time"
)

type NodeManager struct {
	Info    *nodeManagerV1.NodeManagerInfo `json:"info,omitempty"`
	IsUsed  bool                           `json:"isUsed,omitempty"`
	IsExist bool                           `json:"isExist,omitempty"`
}

func GetNodeManagers() []*NodeManager {
	return nodeManagerArr
}

func AddNodeManager(node *nodeManagerV1.NodeManagerInfo) {
	nodeManager := &NodeManager{
		Info:    node,
		IsUsed:  false,
		IsExist: true,
	}
	nodeManagerArr = append(nodeManagerArr, nodeManager)
}

func DelNodeManager(node *nodeManagerV1.NodeManagerInfo) {
	for _, manager := range nodeManagerArr {
		if manager.Info.Endpoint == node.Endpoint {
			manager.IsExist = false
		}
	}
}

func getUnUsedNodeManagers() []*NodeManager {
	res := make([]*NodeManager, 0)
	for _, manager := range nodeManagerArr {
		if !manager.IsUsed && manager.IsExist {
			res = append(res, manager)
		}
	}
	return res
}

func isExistNodeManager(nodeManager *nodeManagerV1.NodeManagerInfo) bool {
	for _, manager := range nodeManagerArr {
		if nodeManager.Endpoint == manager.Info.Endpoint {
			manager.Info.Publickey = nodeManager.Publickey
			return true
		}
	}
	return false
}

func getNodeManager(endPoint string) *NodeManager {
	for _, manager := range nodeManagerArr {
		if manager.Info.Endpoint == endPoint {
			return manager
		}
	}
	return nil
}

func inputNodeManagerChan(manager *NodeManager, nodeManagerClient *models.NodeManagerClient, isSelect bool) bool {
	if nodeManagerClient == nil {
		nodeManagerClient = &models.NodeManagerClient{
			PublicKey:     manager.Info.Publickey,
			Endpoint:      manager.Info.Endpoint,
			Status:        true,
			IsSelected:    isSelect,
			LastHeartTime: time.Now().UnixMilli(),
		}
	}
	serviceClient := operate.ConnNmGrpc(manager.Info.Endpoint)
	if serviceClient == nil {
		log.WithField("endPoint", manager.Info.Endpoint).Error("Connect node manager failed")
		return false
	}
	nodeManagerClient.Status = true
	nodeManagerClient.Client = serviceClient
	nodeManagerClientChan <- nodeManagerClient
	usedNodeManagerClient = append(usedNodeManagerClient, nodeManagerClient)
	manager.IsUsed = true
	return true
}
