package models

import (
	nodeManagerV1 "github.com/odysseus/odysseus-protocol/gen/proto/go/nodemanager/v1"
	"sync"
	"time"
)

type TaskCmd struct {
	ImageName string     `json:"image_name"`
	DockerCmd *DockerCmd `json:"docker_cmd"`
	ApiUrl    string     `json:"api_url"`
}

type DockerCmd struct {
	ContainerPort int64 `json:"container_port"`
	HostIp        string
	HostPort      string
}

type TaskReq struct {
	TaskId     string `json:"task_id"`
	TaskParam  []byte `json:"task_param"`
	TaskResult []byte `json:"task_result"`
}

type TaskParam struct {
	Headers map[string][]string `json:"headers"`
	Queries map[string]string   `json:"queries"`
	Body    []byte              `json:"body"`
}

type TaskResult struct {
	TaskHttpHeaders    []byte
	TaskExecTime       int64
	TaskHttpStatusCode int32
	TaskRespBody       []byte
	TaskIsSuccess      bool
}

type ApiResp struct {
	TaskId     string `json:"task_id"`
	TaskResult []byte `json:"task_result"`
	TaskUid    string `json:"task_uid"`
	TaskFee    string `json:"task_fee"`
	IsSuccess  bool   `json:"is_success"`
	TaskError  string `json:"task_error"`
}

type HardwareRequire struct {
	DiskSize   string     `json:"disk_size"`
	Gpus       []*GpuInfo `json:"gpus"`
	MemorySize string     `json:"memory_size"`
}

type GpuInfo struct {
	Gpu string `json:"gpu"`
}

type ModelInfo struct {
	Time            time.Time        `json:"time"`
	Count           int64            `json:"count"`
	HardwareRequire *HardwareRequire `json:"hardware_require"`
	Kind            int64            `json:"kind"`
	TaskId          uint64           `json:"task_id"`
	User            string           `json:"user"`
	Pwd             string           `json:"pwd"`
	SignUrl         string           `json:"sign_url"`
	ImageName       string           `json:"image_name"`
	//OutPutJson      string           `json:"out_put_json"`
	FileExpiresTime string `json:"file_expires_time"`
	PublishStatus   int    `json:"publish_status"`
}

type ComputeResult struct {
	Code string `json:"code"`
	Msg  string `json:"msg"`
	Data string `json:"data"`
}

type BenefitAddressInfo struct {
	Address   string `json:"address"`
	Timestamp int64  `json:"timestamp"`
}

type NodeManagerClient struct {
	mutex         sync.Mutex
	LastHeartTime time.Time
	PublicKey     string
	Endpoint      string
	Client        nodeManagerV1.NodeManagerServiceClient
	Status        bool
	IsDel         bool
	IsSelected    bool
}

func (n *NodeManagerClient) GetLastHeartTime() time.Time {
	n.mutex.Lock()
	defer n.mutex.Unlock()
	return n.LastHeartTime
}

func (n *NodeManagerClient) UpdateLastHeartTime(time time.Time) {
	n.mutex.Lock()
	n.LastHeartTime = time
	n.mutex.Unlock()
}

func (n *NodeManagerClient) GetStatus() bool {
	n.mutex.Lock()
	defer n.mutex.Unlock()
	return n.Status
}

func (n *NodeManagerClient) UpdateStatus(status bool) {
	n.mutex.Lock()
	defer n.mutex.Unlock()
	n.Status = status
}
