package operate

import (
	"example.com/m/conf"
	"example.com/m/log"
	"github.com/docker/docker/client"
	nodemanagerV1 "github.com/odysseus/odysseus-protocol/gen/proto/go/nodemanager/v1"
	witnessv1 "github.com/odysseus/odysseus-protocol/gen/proto/go/witness/v1"
	"google.golang.org/grpc"
	"google.golang.org/grpc/credentials/insecure"
)

func ConnNmGrpc(endpoint string) nodemanagerV1.NodeManagerServiceClient {
	conn := connGrpc(endpoint)
	if conn != nil {
		return nodemanagerV1.NewNodeManagerServiceClient(conn)
	}
	return nil
}

func ConnValidatorGrpc(endpoint string) witnessv1.WitnessServiceClient {
	conn := connGrpc(endpoint)
	if conn != nil {
		return witnessv1.NewWitnessServiceClient(conn)
	}
	return nil
}

func GetDockerClient() (*client.Client, error) {
	dockerClient, err := client.NewClientWithOpts(client.WithAPIVersionNegotiation(), client.WithHost(conf.GetConfig().DockerServer))
	if err != nil {
		log.Error("Error create docker client: ", err)
		return nil, err
	}
	return dockerClient, nil
}

func connGrpc(endpoint string) *grpc.ClientConn {
	dial, err := grpc.Dial(endpoint, grpc.WithTransportCredentials(insecure.NewCredentials()),
		grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(1024*1024*1024),
			grpc.MaxCallSendMsgSize(1024*1024*1024)),
	)
	if err != nil {
		log.Error("Dial error:", err)
		return nil
	}
	return dial
}
