package main

import (
	"example.com/m/conf"
	"example.com/m/log"
	"example.com/m/nm"
	"fmt"
	"github.com/astaxie/beego"
	"github.com/fsnotify/fsnotify"
	"github.com/spf13/cobra"
	"github.com/spf13/viper"
	"os"
)

var (
	rewardAddr, dockerServer, externalIp, opSys string
)

func init() {
	RootCmd.PersistentFlags().StringVarP(&rewardAddr, "reward", "r", "", "please enter a reward address")
	RootCmd.PersistentFlags().StringVarP(&dockerServer, "docker_server", "d", "", "please enter docker server address")
	RootCmd.PersistentFlags().StringVarP(&externalIp, "externalIp", "e", "", "please enter server external ip address")
	RootCmd.PersistentFlags().StringVarP(&opSys, "opSys", "s", "", "please enter you op sys name : win、linux、mac")
	cobra.OnInitialize(initConfig)
}

// RootCmd represents the base command when called without any subcommands
var RootCmd = &cobra.Command{
	Use:   "miner",
	Short: "The miner command-line interface",
	Long:  ``,
	Run: func(cmd *cobra.Command, args []string) {
		if rewardAddr == "" {
			log.Error("Enter reward address is not nil")
			return
		}
		if opSys != "" {
			if !conf.GetConfig().SetOpSys(opSys) {
				log.Error("Enter op sys no support")
				return
			}
		}
		isSetDockerServer := conf.GetConfig().SetDockerServerUrl(dockerServer)
		if !isSetDockerServer {
			log.Error("Enter right docker server address:", dockerServer)
			return
		}
		log.Info("Enter docker server url:", dockerServer)
		isSetReward := conf.GetConfig().SetRewardAddress(rewardAddr)
		if !isSetReward {
			log.Error("Please set right reward address")
			return
		}
		conf.GetConfig().SetExternalIp(externalIp)
		log.Info("Enter reward address:", rewardAddr)
		log.InitLog(log.LogConfig{Path: "logs", Level: "debug", Save: 3})
		go nm.StartMonitor()
		beego.Run()
	},
}

func initConfig() {
	// 设置配置文件的名称（不包含扩展名)
	viper.SetConfigName("config")

	// 设置配置文件的类型
	viper.SetConfigType("json")

	// 设置配置文件所在的目录
	viper.AddConfigPath(".")

	viper.AutomaticEnv()

	viper.WatchConfig()

	viper.OnConfigChange(func(e fsnotify.Event) {
		// 配置文件发生变更之后会调用的回调函数
		log.Warn("The configuration file has been modified...........")
		err := viper.Unmarshal(conf.GetConfig())
		if err != nil {
			log.WithError(err).Error("Viper unmarshal cfg error:")
			panic(fmt.Errorf("Viper unmarshal conf failed, err:%s \n", err))
		}
		conf.GetConfig().UpdateFiledInfo()
		log.Info("Config file changed success:", e.Name)
	})

	// 读取配置文件
	if err := viper.ReadInConfig(); err != nil {
		panic(fmt.Errorf("Error reading config file: %s ", err.Error()))
	}

	err := viper.Unmarshal(conf.GetConfig())
	if err != nil {
		// handle error
		log.Error("Viper unmarshal cfg error:", err)
		panic("Viper unmarshal cfg error")
	}
	conf.GetConfig().UpdateFiledInfo()
}

func Execute() {
	if err := RootCmd.Execute(); err != nil {
		log.Error("root cmd execute failed", err)
		os.Exit(-1)
	}
}
