package nm

import (
	"context"
	"example.com/m/conf"
	"example.com/m/log"
	"example.com/m/operate"
	nodeManagerV1 "github.com/odysseus/odysseus-protocol/gen/proto/go/nodemanager/v1"
	"google.golang.org/grpc"
	"time"
)

func monitorNodeManagerSeed() {
	ticker := time.NewTicker(time.Second * 1)
	for {
		select {
		case <-ticker.C:
			seed := conf.GetConfig().NmSeed
			log.Info("Nm seed url:", seed)
			seedServiceClient := operate.ConnNmGrpc(seed)
			if seedServiceClient == nil {
				panic("Dial nm seed service client failed")
			}
			list, err := seedServiceClient.ManagerList(context.Background(), &nodeManagerV1.ManagerListRequest{}, grpc.EmptyCallOption{})
			if err != nil {
				panic("Nm seed seed service is dealing")
			}
			if list.GetManagers() == nil || len(list.GetManagers()) == 0 {
				continue
			}
			for _, node := range list.GetManagers() {
				if isExistNodeManager(node.Endpoint) {
					continue
				}
				nodeManagerArr = append(nodeManagerArr, &NodeManager{Info: node, IsUsed: false, IsExist: true})
			}
			isInit = false
			ticker = time.NewTicker(time.Minute * 10)
		}
	}
}
