package controllers

import (
	"github.com/astaxie/beego"
	"github.com/astaxie/beego/logs"
)

type BaseController struct {
	beego.Controller
}

func (d *BaseController) ResponseInfo(code int, msg interface{}, result interface{}) {
	switch code {
	case 500:
		logs.Error(msg, result)
		d.Data["json"] = map[string]interface{}{"code": "500", "msg": msg, "data": result}
	case 200:
		logs.Info(msg, result)
		d.Data["json"] = map[string]interface{}{"code": "200", "msg": msg, "data": result}
	}
	d.ServeJSON()
}
