package controllers

import (
	"encoding/json"
	"example.com/m/conf"
	"example.com/m/models"
	"example.com/m/nm"
	"example.com/m/operate"
	"example.com/m/utils"
	nodemanagerV2 "github.com/odysseus/odysseus-protocol/gen/proto/go/nodemanager/v2"
	"io"
	"strings"
	"time"
)

type NodeController struct {
	BaseController
}

func (c *NodeController) SetNmSeed() {
	bodyReq, err := io.ReadAll(c.Ctx.Request.Body)
	if err != nil || bodyReq == nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	req := &models.SeedUrl{}
	err = json.Unmarshal(bodyReq, req)
	if err != nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	serviceClient := operate.ConnNmGrpc(req.Seed)
	if serviceClient == nil {
		c.ResponseInfo(500, "seed is not connected", "")
	}
	conf.GetConfig().SetNmSeed(req.Seed)
	c.ResponseInfo(200, "set seed successful", "")
}

func (c *NodeController) SetBenefitAddress() {
	bodyReq, err := io.ReadAll(c.Ctx.Request.Body)
	if err != nil || bodyReq == nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	req := &models.BenefitAddressReq{}
	err = json.Unmarshal(bodyReq, req)
	if err != nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	if !conf.GetConfig().SetBenefitAddress(req.Address) {
		c.ResponseInfo(500, "param is not address", "")
		return
	}
	isExist := false
	for _, s := range nm.HistoryBenefitAcc {
		if strings.ToLower(s.Address) == strings.ToLower(req.Address) && !s.IsDel {
			isExist = true
		}
	}
	if !isExist {
		nm.HistoryBenefitAcc = append(nm.HistoryBenefitAcc, &models.BenefitAddressStruct{Address: req.Address, IsDel: false})
		err = utils.WriteBenefitFile(nm.HistoryBenefitAcc)
		if err != nil {
			c.ResponseInfo(500, "Write benefit file failed", "")
		}
	}
	c.ResponseInfo(200, "set benefit address successful", "")
}

func (c *NodeController) ListHistoryBenefitAddress() {
	fileBenefitAcc, _ := utils.ReadBenefitFile()
	res := make([]string, 0)
	for _, addressStruct := range fileBenefitAcc {
		if addressStruct.IsDel {
			continue
		}
		res = append(res, addressStruct.Address)
	}
	c.ResponseInfo(200, "list history benefit address successful", res)
}

func (c *NodeController) AddNodeManager() {
	bodyReq, err := io.ReadAll(c.Ctx.Request.Body)
	if err != nil || bodyReq == nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	req := &models.NodeManagerReq{}
	err = json.Unmarshal(bodyReq, req)
	if err != nil || req.PublicKey == "" || req.EndPoint == "" {
		c.ResponseInfo(500, "param error", "")
		return
	}
	nodeManager := &nodemanagerV2.NodeManagerInfo{
		Publickey: req.PublicKey,
		Endpoint:  req.EndPoint,
	}
	nm.AddNodeManager(nodeManager)
	c.ResponseInfo(200, "add node manager successful", "")

}

func (c *NodeController) GetNodeManagers() {
	manager := nm.GetNodeManagers()
	res := make([]*nm.NodeManager, 0)
	for _, nodeManager := range manager {
		if !nodeManager.IsExist {
			continue
		}
		if nodeManager.IsUsed {
			res = append(res, nodeManager)
		}
	}
	c.ResponseInfo(200, "Get used node manager successful", res)
}

func (c *NodeController) UpdateRecvStatus() {
	bodyReq, err := io.ReadAll(c.Ctx.Request.Body)
	if err != nil || bodyReq == nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	req := &models.RecvTask{}
	err = json.Unmarshal(bodyReq, req)
	if err != nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	if nm.IsRecvTask && req.IsRecv {
		c.ResponseInfo(500, "The task current is recv status , don't need setting", "")
		return
	}
	if req.IsRecv && !nm.IsRunning {
		go nm.StartMonitor()
	}
	if !nm.IsRecvTask && req.IsRecv {
		nm.RunningState.RunningTime = time.Now().Unix()
		nm.RunningState.CompletedTaskCount = 0
		circularBuffer = &models.CircularBuffer{}
	}
	nm.IsRecvTask = req.IsRecv
	c.ResponseInfo(200, "update recv status successful", "")
}

func (c *NodeController) GetRecvStatus() {
	c.ResponseInfo(200, "get recv status  successful", nm.IsRecvTask)
}

func (c *NodeController) GetConfigInfo() {
	c.ResponseInfo(200, "get config successful", conf.GetConfig())
}

func (c *NodeController) GetBenefit() {
	c.ResponseInfo(200, "get benefit address successful", conf.GetConfig().BenefitAddress)
}

func (c *NodeController) SwitchMode() {
	bodyReq, err := io.ReadAll(c.Ctx.Request.Body)
	if err != nil || bodyReq == nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	req := &models.RunMode{}
	err = json.Unmarshal(bodyReq, req)
	if err != nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	switch req.Type {
	case models.BasicMode:
		{

		}
	case models.HealthMode:
		{

		}
	case models.SaveMode:
		{

		}
	}
	conf.GetConfig().RunMode = req.Type
	c.ResponseInfo(200, "switch mode successful", "")
}

func (c *NodeController) GetRunMode() {
	c.ResponseInfo(200, "switch mode successful", conf.GetConfig().RunMode)
}

func (c *NodeController) DelBenefitAddress() {
	bodyReq, err := io.ReadAll(c.Ctx.Request.Body)
	if err != nil || bodyReq == nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	req := &models.BenefitAddressReq{}
	err = json.Unmarshal(bodyReq, req)
	if err != nil {
		c.ResponseInfo(500, "param error", "")
		return
	}
	if req.Address == conf.GetConfig().BenefitAddress {
		c.ResponseInfo(500, "Don't del current benefit address", "")
		return
	}
	isExist := false
	for _, s := range nm.HistoryBenefitAcc {
		if strings.ToLower(s.Address) == strings.ToLower(req.Address) {
			s.IsDel = true
			isExist = true
		}
	}
	if !isExist {
		c.ResponseInfo(500, "The account not exist,don't del", "")
		return
	}
	err = utils.WriteBenefitFile(nm.HistoryBenefitAcc)
	if err != nil {
		c.ResponseInfo(500, "Write benefit acc file failed", "")
		return
	}
	c.ResponseInfo(200, "The account del successful ", "")
}
