package nm

import (
	"example.com/m/models"
	nodemanagerV2 "github.com/odysseus/odysseus-protocol/gen/proto/go/nodemanager/v2"
	"time"
)

type NodeManager struct {
	Info    *nodemanagerV2.NodeManagerInfo `json:"info,omitempty"`
	IsUsed  bool                           `json:"isUsed,omitempty"`
	IsExist bool                           `json:"isExist,omitempty"`
}

var (
	HistoryBenefitAcc   []*models.BenefitAddressStruct
	RunningState        *models.RunningState
	IsRecvTask          bool
	IsUpdateBenefitAddr bool
)

func init() {
	IsRecvTask = false
	IsUpdateBenefitAddr = false
	HistoryBenefitAcc = make([]*models.BenefitAddressStruct, 0)
	RunningState = &models.RunningState{
		RunningTime:        time.Now().Unix(),
		CompletedTaskCount: 0,
		NmIpAddr:           "",
		NmDelayTime:        0,
		NmLocation:         "",
	}
}

func GetNodeManagers() []*NodeManager {
	return nodeManagerArr
}

func AddNodeManager(node *nodemanagerV2.NodeManagerInfo) {
	nodeManager := &NodeManager{
		Info:    node,
		IsUsed:  false,
		IsExist: true,
	}
	nodeManagerArr = append(nodeManagerArr, nodeManager)
}

func DelNodeManager(node *nodemanagerV2.NodeManagerInfo) {
	for _, manager := range nodeManagerArr {
		if manager.Info.Endpoint == node.Endpoint {
			manager.IsExist = false
		}
	}
}

func getUnUsedNodeManagers() []*NodeManager {
	res := make([]*NodeManager, 0)
	for _, manager := range nodeManagerArr {
		if !manager.IsUsed && manager.IsExist {
			res = append(res, manager)
		}
	}
	return res
}

func isExistNodeManager(nodeManager *nodemanagerV2.NodeManagerInfo) bool {
	for _, manager := range nodeManagerArr {
		if nodeManager.Endpoint == manager.Info.Endpoint {
			//manager.Info.Publickey = nodeManager.Publickey
			return true
		}
	}
	return false
}

func getNodeManager(endPoint string) *NodeManager {
	for _, manager := range nodeManagerArr {
		if manager.Info.Endpoint == endPoint {
			return manager
		}
	}
	return nil
}
