package models

import (
	nodeManagerV1 "github.com/odysseus/odysseus-protocol/gen/proto/go/nodemanager/v1"
	"sync"
)

type TaskCmd struct {
	ImageName string     `json:"image_name"`
	DockerCmd *DockerCmd `json:"docker_cmd"`
	ApiUrl    string     `json:"api_url"`
}

type DockerCmd struct {
	ContainerPort string `json:"container_port"`
	HostIp        string
	HostPort      string
}

type TaskReq struct {
	TaskId     string `json:"task_id"`
	TaskParam  []byte `json:"task_param"`
	TaskResult []byte `json:"task_result"`
}

type ModelInfo struct {
	TaskId       uint64 `json:"task_id"`
	User         string `json:"user"`
	Pwd          string `json:"pwd"`
	Repository   string `json:"repository"`
	SignUrl      string `json:"sign_url"`
	ImageName    string `json:"image_name"`
	DiskSize     int64  `json:"disk_size"`
	MemorySize   int64  `json:"memory_size"`
	IsImageExist bool
}

type ComputeResult struct {
	Code string `json:"code"`
	Msg  string `json:"msg"`
	Data string `json:"data"`
}

type NodeManagerClient struct {
	mutex         sync.Mutex
	LastHeartTime int64
	PublicKey     string
	Endpoint      string
	Client        nodeManagerV1.NodeManagerServiceClient
	Status        bool
	IsDel         bool
}

func (n *NodeManagerClient) GetLastHeartTime() int64 {
	n.mutex.Lock()
	defer n.mutex.Unlock()
	return n.LastHeartTime
}

func (n *NodeManagerClient) UpdateLastHeartTime(time int64) {
	n.mutex.Lock()
	n.LastHeartTime = time
	n.mutex.Unlock()
}

func (n *NodeManagerClient) GetStatus() bool {
	n.mutex.Lock()
	defer n.mutex.Unlock()
	return n.Status
}

func (n *NodeManagerClient) UpdateStatus(status bool) {
	n.mutex.Lock()
	n.Status = status
	n.mutex.Unlock()
}
