package test

import (
	"fmt"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/crypto"
	"testing"
)

func Test_initConfig(t *testing.T) {
	prvKey, _ := crypto.HexToECDSA("e3b097b0c171e2489973a277b1546392db97e359505cd64b9b52966cb87a0f08")
	fmt.Println("prvKey:", prvKey)
	pubKey := common.Bytes2Hex(crypto.FromECDSAPub(&prvKey.PublicKey))
	fmt.Println("pubKey:", pubKey)
	address := crypto.PubkeyToAddress(prvKey.PublicKey)
	fmt.Println("address:", address)
}
