package config

import (
	"github.com/BurntSushi/toml"
	log "github.com/sirupsen/logrus"
	"io/ioutil"
)

type RedisConfig struct {
	Addr     string `json:"addr" toml:"addr"`
	Password string `json:"password" toml:"password"`
	DbIndex  int    `json:"db_index" toml:"db_index"`
}
type KafkaConfig struct {
	Brokers      string `json:"brokers" toml:"brokers"`
	ReceiptTopic string `json:"receipt_topic" toml:"receipt_topic"`
	TaskTopic    string `json:"task_topic" toml:"task_topic"`
}

type MysqlConfig struct {
	Host   string `json:"host" toml:"host"`
	Port   int    `json:"port" toml:"port"`
	User   string `json:"user" toml:"user"`
	Passwd string `json:"password" toml:"password"`
	DbName string `json:"database" toml:"database"`
}

type Config struct {
	Endpoint      string      `json:"endpoint" toml:"endpoint"`
	MetricPort    int         `json:"metrics_port" toml:"metrics_port"`
	Routines      int         `json:"routines" toml:"routines"`
	MaxNmUpdateEx int         `json:"max_nm_update_ex" toml:"max_nm_update_ex"`
	Redis         RedisConfig `json:"redis" toml:"redis"`
	Kafka         KafkaConfig `json:"kafka" toml:"kafka"`
	DbConfig      MysqlConfig `json:"mysql" toml:"mysql"`
}

var _cfg *Config = nil

func ParseConfig(path string) (*Config, error) {
	data, err := ioutil.ReadFile(path)
	if err != nil {
		log.Error("get config failed", "err", err)
		panic(err)
	}
	err = toml.Unmarshal(data, &_cfg)
	if err != nil {
		log.Error("unmarshal config failed", "err", err)
		panic(err)
	}
	return _cfg, nil
}

func GetConfig() *Config {
	return _cfg
}
