package utils

import (
	"crypto/ecdsa"
	"encoding/hex"
	"github.com/ethereum/go-ethereum/crypto"
	"strings"
)

func HexToPrivatekey(key string) (*ecdsa.PrivateKey, error) {
	return crypto.HexToECDSA(key)
}

func PrivatekeyToHex(key *ecdsa.PrivateKey) string {
	return hex.EncodeToString(crypto.FromECDSA(key))
}

func PrivatekeyToAddress(key *ecdsa.PrivateKey) string {
	return crypto.PubkeyToAddress(key.PublicKey).String()
}

func PubkeyToAddress(key *ecdsa.PublicKey) string {
	return crypto.PubkeyToAddress(*key).String()
}

func PubkeyToHex(key *ecdsa.PublicKey) string {
	pub := crypto.FromECDSAPub(key)
	return hex.EncodeToString(pub)
}

func HexToPubkey(key string) (*ecdsa.PublicKey, error) {
	if strings.HasPrefix(key, "0x") {
		key = key[2:]
	}
	pub, err := hex.DecodeString(key)
	if err != nil {
		return nil, err
	}
	return crypto.UnmarshalPubkey(pub)
}
