package utils

import (
	"fmt"
	"github.com/google/uuid"
	basev1 "github.com/odysseus/odysseus-protocol/gen/proto/go/base/v1"
	"strings"
	"testing"
	"time"
)

func Test(t *testing.T) {
	broker := "192.168.1.220:9092"
	brokers := strings.Split(broker, ";")
	producer, err := NewKafkaProducer(brokers)
	if err != nil {
		t.Fatalf("NewKafkaProducer failed with err:%s", err.Error())
	}

	for i := 0; i < 100; i++ {
		taskReceipt := &basev1.TaskReceipt{
			TaskUid: uuid.NewString(),
		}
		err = FireTaskReceipt(producer, taskReceipt, "taskreceipt")
		if err != nil {
			t.Fatalf("FireTaskReceipt failed with err:%s", err.Error())
		}
		fmt.Println("send task receipt success")
		time.Sleep(time.Second)
	}

}
