package workerpoper

import (
	"context"
	odysseus "github.com/odysseus/odysseus-protocol/gen/proto/go/base/v1"
	"github.com/odysseus/scheduler/config"
	"github.com/odysseus/scheduler/types"
	"github.com/redis/go-redis/v9"
	log "github.com/sirupsen/logrus"
)

type WorkerPoper interface {
	CanAddBack() bool
	AddBack(worker types.Worker)
	PopWorker(ctx context.Context, rdb *redis.Client, task *odysseus.TaskContent, ex map[string]bool) (types.Worker, error)
}

func NewPopWorker() WorkerPoper {
	switch config.GetConfig().PoperVersion {
	case "v1":
		v1, err := newPoperV1()
		if err != nil {
			log.WithFields(log.Fields{
				"version": "v1",
				"err":     err,
			}).Error("failed to create poper")
			return nil
		}
		return v1
	case "v2":
		v2, err := newPoperV2()
		if err != nil {
			log.WithFields(log.Fields{
				"version": "v2",
				"err":     err,
			}).Error("failed to create poper")
			return nil
		}
		return v2
	default:
		log.WithField("version", config.GetConfig().PoperVersion).Error("unknown poper version")
	}
	return nil
}
