package config

import (
	"flag"

	"github.com/BurntSushi/toml"
)

type Config struct {
	Debug  bool         `toml:"debug"`
	Sender SenderConfig `toml:"sender"`
	MySQL  MysqlConfig  `toml:"mysql"`
	Server ServerConfig `toml:"server"`
}

type SenderConfig struct {
	EmailUsername string `json:"email_username"`
	EmailPassword string `json:"email_password"`
}

type MysqlConfig struct {
	Host        string `toml:"host"`
	Port        int    `toml:"port"`
	User        string `toml:"user"`
	Password    string `toml:"password"`
	Database    string `toml:"database"`
	MaxConn     int    `toml:"max_conn"`
	MaxIdleConn int    `toml:"max_idle_conn"`
}

type ServerConfig struct {
	Listen string `toml:"listen"`
}

var confPath = flag.String("c", "config.toml", "config file path")

func New() (config *Config, err error) {
	config = new(Config)
	_, err = toml.DecodeFile(*confPath, config)
	return
}
