package dao

import (
	dbModel "sdk_api/model/db"

	"gorm.io/gorm"
)

func (d *Dao) CreateUser(user *dbModel.User) (err error) {
	return d.db.Create(user).Error
}

func (d *Dao) CheckUser(platform string, platformId string) (user *dbModel.User, err error) {
	user = &dbModel.User{}
	err = d.db.Model(user).
		Where("platform = ? AND platform_id = ?", platform, platformId).
		First(user).
		Error
	if err == gorm.ErrRecordNotFound {
		return nil, nil
	}
	return
}

func (d *Dao) GetUserByUid(uid string) (user *dbModel.User, err error) {
	user = &dbModel.User{}
	err = d.db.Model(user).
		Where("uid = ?", uid).
		First(user).
		Error
	if err == gorm.ErrRecordNotFound {
		return nil, err
	}
	return
}

func (d *Dao) CreateEmptyUser(user *dbModel.User) (err error) {
	return d.db.Create(user).Error
}

func (d *Dao) SetKeystore(uid, address, keystore string) (err error) {
	// set keystore only not exist
	return d.db.Model(&dbModel.User{}).
		Where("uid = ? AND keystore = ?", uid, "").
		// Update("keystore", keystore).
		Updates(map[string]interface{}{"keystore": keystore, "address": address}).
		Error
}
