package middleware

import (
	"sdk_api/util"

	"github.com/gin-gonic/gin"
	log "github.com/sirupsen/logrus"
)

func JWTMiddleware(c *gin.Context) {
	tokenString := c.GetHeader("Authorization")
	log.Debugln(tokenString)
	if tokenString == "" || len(tokenString) < 7 {
		c.JSON(200, gin.H{
			"code": 1,
			"msg":  "invalid token",
			"data": "",
		})
		c.Abort()
		return
	}

	ok, expired, uid, _, _ := util.ParseJWT(tokenString[7:])
	if !ok {
		c.JSON(200, gin.H{
			"code": 1,
			"msg":  "invalid token",
			"data": "",
		})
		c.Abort()
		return
	}

	if expired {
		c.JSON(200, gin.H{
			"code": 1,
			"msg":  "token expired",
			"data": "",
		})
		c.Abort()
		return
	}

	log.WithField("uid", uid).Debug("jwt uid")
	c.Set("jwt-uid", uid)
	c.Next()
}
