package service

import (
	dbModel "sdk_api/model/db"

	"github.com/google/uuid"
	log "github.com/sirupsen/logrus"
)

func (s *Service) CheckUser(platform string, platformId string) (exist bool, uid, keystore string, err error) {
	user, err := s.d.CheckUser(platform, platformId)
	if err != nil {
		log.WithError(err).Error("get user failed")
		return
	}
	if user == nil {
		uid := uuid.New().String()
		err = s.d.CreateEmptyUser(&dbModel.User{
			Uid:        uid,
			Platform:   platform,
			PlatformId: platformId,
		})
		if err != nil {
			log.WithError(err).Error("create user failed")
			return false, "", "", err
		}

		return false, uid, "", nil
	}
	return user.Keystore != "", user.Uid, user.Keystore, nil
}

func (s *Service) SetKeystore(uid, address, keystore string) (ok bool, err error) {
	user, err := s.d.GetUserByUid(uid)
	if err != nil {
		log.WithError(err).Error("get user failed")
		return
	}
	if user.Keystore != "" {
		log.WithField("uid", uid).Warn("keystore already exist")
		return false, nil
	}
	err = s.d.SetKeystore(uid, address, keystore)
	if err != nil {
		log.WithError(err).Error("set keystore failed")
		return
	}
	return true, nil
}
